/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.jsonrefparser;

import io.zenwave360.jsonrefparser.resolver.RefFormat;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;

public class $Ref {
    public static final String REFERENCE_SEPARATOR = "#/";
    private final String ref;
    private final RefFormat refFormat;
    private final URI uri;
    private final String path;
    private final URI referencingFileURI;

    private $Ref(String ref, RefFormat refFormat, URI uri, String path, URI referencingFileURI) {
        this.ref = ref;
        this.refFormat = refFormat;
        this.uri = uri;
        this.path = path;
        this.referencingFileURI = referencingFileURI;
    }

    public static $Ref of(String ref, URI referencingFileURL) {
        RefFormat refFormat = RefFormat.INTERNAL;
        if ((ref = $Ref.mungedRef(ref)).startsWith("classpath:")) {
            refFormat = RefFormat.CLASSPATH;
        } else if (ref.startsWith("http") || ref.startsWith("https")) {
            refFormat = RefFormat.URL;
        } else if (ref.startsWith(REFERENCE_SEPARATOR)) {
            refFormat = RefFormat.INTERNAL;
        } else if (ref.startsWith(".") || ref.startsWith("/") || ref.indexOf(REFERENCE_SEPARATOR) > 0) {
            refFormat = RefFormat.RELATIVE;
        }
        URI url = null;
        Object path = null;
        if (RefFormat.INTERNAL == refFormat) {
            path = ref;
        } else {
            String[] tokens = ref.split(REFERENCE_SEPARATOR, 2);
            String urlStr = RefFormat.RELATIVE == refFormat ? $Ref.buildUrl(referencingFileURL.toString(), tokens[0]) : tokens[0];
            url = URI.create(urlStr);
            if (tokens.length == 2) {
                path = REFERENCE_SEPARATOR + tokens[1];
            }
        }
        return new $Ref(ref, refFormat, url, (String)path, referencingFileURL);
    }

    public String getRef() {
        return this.ref;
    }

    public RefFormat getRefFormat() {
        return this.refFormat;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getPath() {
        return this.path;
    }

    public URI getReferencingFileURI() {
        return this.referencingFileURI;
    }

    public String toString() {
        return "$Ref {" + (this.uri != null ? this.uri.toString() : "") + this.path + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof $Ref)) {
            return false;
        }
        $Ref that = ($Ref)o;
        return this.ref != null && this.ref.equals(that.ref);
    }

    private static String mungedRef(String refString) {
        if (!(refString == null || refString.contains(":") || refString.startsWith("#") || refString.startsWith("/") || refString.contains("$") || refString.indexOf(".") <= 0)) {
            return "./" + refString;
        }
        return refString;
    }

    private static String buildUrl(String rootPath, String relativePath) {
        int i;
        String[] rootPathParts = rootPath.split("/");
        String[] relPathParts = relativePath.split("/");
        if (rootPath == null || relativePath == null) {
            return null;
        }
        int trimRoot = 0;
        int trimRel = 0;
        if (!"".equals(rootPathParts[rootPathParts.length - 1])) {
            trimRoot = 1;
        }
        if ("".equals(relPathParts[0])) {
            trimRel = 1;
            trimRoot = rootPathParts.length - 3;
        }
        for (i = 0; i < rootPathParts.length && "".equals(rootPathParts[i]); ++i) {
            ++trimRel;
        }
        for (i = 0; i < relPathParts.length; ++i) {
            if (".".equals(relPathParts[i])) {
                ++trimRel;
                continue;
            }
            if (!"..".equals(relPathParts[i])) continue;
            ++trimRel;
            ++trimRoot;
        }
        Object[] outputParts = new String[rootPathParts.length + relPathParts.length - trimRoot - trimRel];
        System.arraycopy(rootPathParts, 0, outputParts, 0, rootPathParts.length - trimRoot);
        System.arraycopy(relPathParts, trimRel, outputParts, rootPathParts.length - trimRoot, relPathParts.length - trimRel);
        return StringUtils.join((Object[])outputParts, (String)"/");
    }
}

