/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.jsonrefparser;

import com.fasterxml.jackson.core.JsonLocation;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import io.zenwave360.jsonrefparser.$Ref;
import io.zenwave360.jsonrefparser.parser.ExtendedJsonContext;
import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;

public class $Refs {
    public boolean circular;
    private final List<String> paths = new ArrayList<String>();
    private final List<String> refs = new ArrayList<String>();
    public ExtendedJsonContext jsonContext;
    private Map<URI, ExtendedJsonContext> jsonContextMap = new HashMap<URI, ExtendedJsonContext>();
    public final URI file;
    public final URI rootDir;
    private List<Pair<$Ref, Object>> originalRefsList = new ArrayList<Pair<$Ref, Object>>();
    private List<Pair<Map, List>> originalAllOfList = new ArrayList<Pair<Map, List>>();

    public $Refs(ExtendedJsonContext jsonContext) {
        this.jsonContext = jsonContext;
        this.file = null;
        this.rootDir = new File(".").toURI();
    }

    public $Refs(ExtendedJsonContext jsonContext, URI file) {
        this.jsonContext = jsonContext;
        this.file = file;
        FilenameUtils.getFullPath((String)file.toString());
        String parentFile = FilenameUtils.getFullPath((String)file.toString()) + (String)(file.getQuery() != null ? "?" + file.getQuery() : "");
        this.rootDir = URI.create(parentFile);
    }

    public List<Pair<$Ref, Object>> getOriginalRefsList() {
        return this.originalRefsList;
    }

    public $Ref getOriginalRef(Object obj) {
        List<Map<String, Object>> originalAllOf = this.getOriginalAllOf(obj);
        return this.originalRefsList.stream().filter(pair -> this.isOriginalRef(obj, pair.getValue(), originalAllOf)).map(pair -> ($Ref)pair.getKey()).findFirst().orElse(null);
    }

    public Object getObjectForRef($Ref ref) {
        return this.originalRefsList.stream().filter(pair -> (($Ref)pair.getKey()).toString().equals(ref.toString())).map(Pair::getValue).findFirst().orElse(null);
    }

    public List<Map<String, Object>> getOriginalAllOf(Object resolvedAllOf) {
        return this.originalAllOfList.stream().filter(pair -> pair.getKey() == resolvedAllOf).map(Pair::getValue).findFirst().orElse(null);
    }

    protected boolean isOriginalRef(Object value, Object savedValue, Object originalAllOf) {
        return value == savedValue || originalAllOf != null && savedValue instanceof Map && ((Map)savedValue).get("allOf") == originalAllOf;
    }

    private $Ref getOriginalRefForAllOf(Object resolvedAllOf) {
        List<Map<String, Object>> originalAllOf;
        if (!(resolvedAllOf instanceof Map) || (originalAllOf = this.getOriginalAllOf((Map)resolvedAllOf)) != null) {
            // empty if block
        }
        return null;
    }

    public void addRef(String ref) {
        if (ref != null && !this.refs.contains(ref)) {
            this.refs.add(ref);
        }
    }

    public void addPath(URL url) {
        if (url != null && !this.paths.contains(url.toExternalForm())) {
            this.paths.add(url.toExternalForm());
        }
    }

    public void addPath(URI uri) {
        if (uri != null && !this.paths.contains(uri.toString())) {
            this.paths.add(uri.toString());
        }
    }

    public void addJsonContext(URI url, ExtendedJsonContext jsonContext) {
        this.jsonContextMap.put(url, jsonContext);
    }

    public void saveOriginalRef($Ref originalRef, Object resolved) {
        if (!originalRef.equals(resolved)) {
            this.originalRefsList.add((Pair<$Ref, Object>)Pair.of((Object)originalRef, (Object)resolved));
        }
    }

    public void saveOriginalAllOf(Map<String, Object> resolvedAllOf, List originalAllOf) {
        this.originalAllOfList.add((Pair<Map, List>)Pair.of(resolvedAllOf, (Object)originalAllOf));
    }

    public Map<String, Object> schema() {
        return (Map)this.jsonContext.json();
    }

    public List<String> paths(String ... types) {
        if (types == null || types.length == 0) {
            return this.paths;
        }
        return this.paths.stream().filter(path -> path.startsWith(types[0])).collect(Collectors.toList());
    }

    public List<String> refs(String ... types) {
        if (types == null || types.length == 0) {
            return this.refs;
        }
        return this.refs.stream().filter(ref -> ref.startsWith(types[0])).collect(Collectors.toList());
    }

    public Pair<JsonLocation, JsonLocation> getJsonLocationRange(String jsonPath) {
        return this.jsonContext.getJsonLocationsMap().get(jsonPath);
    }

    public Pair<JsonLocation, JsonLocation> getJsonLocationRange(URI fileURI, String jsonPath) {
        if (this.jsonContextMap.containsKey(fileURI)) {
            return this.jsonContextMap.get(fileURI).getJsonLocationsMap().get(jsonPath);
        }
        return null;
    }

    public Object get(String $ref) {
        try {
            return this.jsonContext.read($ref, new Predicate[0]);
        }
        catch (UndeclaredThrowableException e) {
            if (e.getUndeclaredThrowable().getCause() instanceof PathNotFoundException) {
                return null;
            }
            throw e;
        }
    }

    public <T> T get(String $ref, Class<T> type) {
        try {
            return (T)this.jsonContext.read($ref, type, new Predicate[0]);
        }
        catch (UndeclaredThrowableException e) {
            if (e.getUndeclaredThrowable().getCause() instanceof PathNotFoundException) {
                return null;
            }
            throw e;
        }
    }

    public void set(String $ref, Object value) {
        this.jsonContext.set($ref, value, new Predicate[0]);
    }
}

