/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.jsonrefparser.parser;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CustomJacksonJsonProvider
extends JacksonJsonProvider {
    private Logger log = LoggerFactory.getLogger(CustomJacksonJsonProvider.class);

    public CustomJacksonJsonProvider(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    public boolean isArray(Object obj) {
        this.log.trace("isArray {}", obj != null ? obj.getClass() : null);
        return obj instanceof List || obj instanceof Map && ((Map)obj).keySet().stream().allMatch(key -> NumberUtils.isDigits((String)key));
    }

    public Object getArrayIndex(Object obj, int idx) {
        return obj instanceof Map ? ((Map)obj).get("" + idx) : ((List)obj).get(idx);
    }

    public boolean isMap(Object obj) {
        this.log.trace("isMap {}", obj != null ? obj.getClass() : null);
        return obj instanceof Map || obj instanceof List;
    }

    public Collection<String> getPropertyKeys(Object obj) {
        if (obj instanceof List) {
            return IntStream.range(0, ((List)obj).size()).boxed().map(i -> String.valueOf(i)).collect(Collectors.toList());
        }
        return ((Map)obj).keySet();
    }

    public Object getMapValue(Object obj, String key) {
        this.log.trace("getMapValue {} {}", obj.getClass(), (Object)key);
        if (obj instanceof List) {
            Integer index = this.parseIndex(key);
            return index != null ? this.getArrayIndex(obj, index) : JsonProvider.UNDEFINED;
        }
        return super.getMapValue(obj, key);
    }

    public void setProperty(Object obj, Object key, Object value) {
        this.log.trace("setProperty {} {} {}", new Object[]{obj.getClass(), key, value.getClass()});
        if (obj instanceof Map) {
            ((Map)obj).put(key.toString(), value);
        } else {
            this.setArrayIndex(obj, this.parseIndex(key.toString()), value);
        }
    }

    public void removeProperty(Object obj, Object key) {
        this.log.trace("removeProperty {} {}", obj.getClass(), key);
        if (obj instanceof Map) {
            ((Map)obj).remove(key.toString());
        } else {
            ((List)obj).remove(this.parseIndex(key.toString()));
        }
    }

    private Integer parseIndex(String key) {
        return NumberUtils.isDigits((String)(key = key.replaceAll("['\"]", ""))) ? Integer.valueOf(Integer.parseInt(key)) : null;
    }
}

