/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.jsonrefparser.parser;

import com.fasterxml.jackson.core.JsonLocation;
import com.jayway.jsonpath.DocumentContext;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;

public interface ExtendedJsonContext
extends DocumentContext {
    public Map<String, Pair<JsonLocation, JsonLocation>> getJsonLocationsMap();

    public static ExtendedJsonContext of(DocumentContext jsonContext, Map<String, Pair<JsonLocation, JsonLocation>> locations) {
        BiFunction<Class, Method, Method> findMethod = (clazz, m) -> {
            try {
                return clazz.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        };
        Supplier<Map> getJsonLocationsMap = () -> locations;
        return (ExtendedJsonContext)Proxy.newProxyInstance(jsonContext.getClass().getClassLoader(), new Class[]{ExtendedJsonContext.class}, (proxy, method, args) -> {
            if ("toString".equals(method.getName())) {
                return "ExtendedJsonContext@" + jsonContext.hashCode() + locations.hashCode();
            }
            Method m = (Method)findMethod.apply(DocumentContext.class, method);
            if (m != null) {
                return m.invoke((Object)jsonContext, args);
            }
            m = (Method)findMethod.apply(ExtendedJsonContext.class, method);
            if (m != null) {
                return getJsonLocationsMap.get();
            }
            return method.invoke(proxy, args);
        });
    }
}

