/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.jsonrefparser.parser;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import io.zenwave360.jsonrefparser.parser.CustomJacksonJsonProvider;
import io.zenwave360.jsonrefparser.parser.CustomYAMLFactory;
import io.zenwave360.jsonrefparser.parser.ExtendedJsonContext;
import io.zenwave360.jsonrefparser.parser.JsonDeserializerWithLocations;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.EnumSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger log = LoggerFactory.getLogger(Parser.class);
    private static ClassLoader resourceClassLoader = Parser.class.getClassLoader();

    public static void withResourceClassLoader(ClassLoader resourceClassLoader) {
        if (resourceClassLoader != null) {
            Parser.resourceClassLoader = resourceClassLoader;
        }
    }

    public static ExtendedJsonContext parse(URI uri) throws IOException {
        if ("classpath".contentEquals(uri.getScheme())) {
            return Parser.parse(resourceClassLoader.getResourceAsStream(uri.getPath().replaceFirst("^/", "")), uri);
        }
        return Parser.parse(new FileInputStream(new File(uri)), uri);
    }

    public static ExtendedJsonContext parse(File file) throws IOException {
        return Parser.parse(new FileInputStream(file), file);
    }

    public static ExtendedJsonContext parse(String content) {
        try {
            return Parser.parse(new ByteArrayInputStream(content.getBytes()), "string");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ExtendedJsonContext parse(InputStream inputStream, Object source) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("$RefParser.parse(): InputStream not found [" + source + "]");
        }
        final ObjectMapper mapper = new ObjectMapper((JsonFactory)new CustomYAMLFactory());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        JsonDeserializerWithLocations jsonDeserializerWithLocations = new JsonDeserializerWithLocations();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Object.class, (JsonDeserializer)jsonDeserializerWithLocations);
        mapper.registerModule((Module)module);
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final JsonProvider jsonProvider;
            private final MappingProvider mappingProvider;
            {
                this.jsonProvider = new CustomJacksonJsonProvider(mapper);
                this.mappingProvider = new JacksonMappingProvider(mapper);
            }

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
        String content = new String(inputStream.readAllBytes());
        DocumentContext parsed = JsonPath.parse((String)content);
        ExtendedJsonContext.of(parsed, jsonDeserializerWithLocations.getLocations()).toString();
        return ExtendedJsonContext.of(parsed, jsonDeserializerWithLocations.getLocations());
    }
}

