/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.jsonrefparser.resolver;

import io.zenwave360.jsonrefparser.$Ref;
import io.zenwave360.jsonrefparser.AuthenticationValue;
import io.zenwave360.jsonrefparser.resolver.Resolver;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResolver
implements Resolver {
    private static Logger log = LoggerFactory.getLogger(HttpResolver.class);
    public static final String TRUST_ALL = String.format("%s.trustAll", HttpResolver.class.getName());
    private static final String ACCEPT_HEADER_VALUE = "application/json, application/yaml, */*";
    private static final String USER_AGENT_HEADER_VALUE = "Apache-HttpClient/$JSONSchemaRefParserJVM";
    private final ConnectionConfigurator CONNECTION_CONFIGURATOR = this.createConnectionConfigurator();
    private List<AuthenticationValue> authenticationValues = new ArrayList<AuthenticationValue>();

    public HttpResolver withAuthentication(AuthenticationValue authenticationValue) {
        this.authenticationValues.add(authenticationValue);
        return this;
    }

    @Override
    public String resolve($Ref $ref) {
        try {
            return this.downloadUrlToString($ref.getURI().toString(), this.authenticationValues);
        }
        catch (FileNotFoundException e) {
            throw new Resolver.MissingResourceException("File not found: " + $ref.getURI(), e);
        }
        catch (Exception e) {
            log.error("Error resolving {}", (Object)$ref, (Object)e);
            throw new RuntimeException(e);
        }
    }

    protected String downloadUrlToString(String url, List<AuthenticationValue> auths) throws Exception {
        InputStream is = null;
        BufferedReader br = null;
        try {
            URLConnection conn;
            do {
                URL inUrl = new URL(this.cleanUrl(url));
                ArrayList<AuthenticationValue> query = new ArrayList<AuthenticationValue>();
                ArrayList<AuthenticationValue> header = new ArrayList<AuthenticationValue>();
                if (auths != null && auths.size() > 0) {
                    for (AuthenticationValue auth : auths) {
                        if (auth.getUrlMatcher() != null && !auth.getUrlMatcher().test(inUrl)) continue;
                        if (AuthenticationValue.AuthenticationType.HEADER == auth.getType()) {
                            header.add(auth);
                        }
                        if (AuthenticationValue.AuthenticationType.QUERY != auth.getType()) continue;
                        query.add(auth);
                    }
                }
                if (!query.isEmpty()) {
                    URI inUri = inUrl.toURI();
                    StringBuilder newQuery = new StringBuilder(inUri.getQuery() == null ? "" : inUri.getQuery());
                    for (AuthenticationValue item : query) {
                        if (newQuery.length() > 0) {
                            newQuery.append("&");
                        }
                        newQuery.append(URLEncoder.encode(item.getKey(), StandardCharsets.UTF_8.name())).append("=").append(URLEncoder.encode(item.getValue(), StandardCharsets.UTF_8.name()));
                    }
                    conn = new URI(inUri.getScheme(), inUri.getAuthority(), inUri.getPath(), newQuery.toString(), inUri.getFragment()).toURL().openConnection();
                } else {
                    conn = inUrl.openConnection();
                }
                this.CONNECTION_CONFIGURATOR.process(conn);
                for (AuthenticationValue item : header) {
                    conn.setRequestProperty(item.getKey(), item.getValue());
                }
                conn.setRequestProperty("Accept", ACCEPT_HEADER_VALUE);
                conn.setRequestProperty("User-Agent", USER_AGENT_HEADER_VALUE);
                conn.connect();
                url = ((HttpURLConnection)conn).getHeaderField("Location");
            } while (301 == ((HttpURLConnection)conn).getResponseCode());
            InputStream in = conn.getInputStream();
            StringBuilder contents = new StringBuilder();
            BufferedReader input = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            int i = 0;
            while (i != -1) {
                char c = (char)i;
                if (!Character.isISOControl(c)) {
                    contents.append((char)i);
                }
                if (c == '\n') {
                    contents.append('\n');
                }
                i = input.read();
            }
            in.close();
            String string = contents.toString();
            return string;
        }
        catch (SSLProtocolException e) {
            log.warn("there is a problem with the target SSL certificate");
            log.warn("**** you may want to run with -Djsse.enableSNIExtension=false\n\n");
            log.error("unable to read", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unable to read url {} {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    private String cleanUrl(String url) {
        String result = null;
        try {
            result = url.replaceAll("\\{", "%7B").replaceAll("\\}", "%7D").replaceAll(" ", "%20");
        }
        catch (PatternSyntaxException ignored) {
            log.debug("Pattern exception cleaning url", (Throwable)ignored);
        }
        return result;
    }

    private ConnectionConfigurator createConnectionConfigurator() {
        if (Boolean.parseBoolean(System.getProperty(TRUST_ALL))) {
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                final SSLSocketFactory sf = sc.getSocketFactory();
                final HostnameVerifier trustAllNames = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
                return new ConnectionConfigurator(){

                    @Override
                    public void process(URLConnection connection) {
                        if (connection instanceof HttpsURLConnection) {
                            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                            httpsConnection.setSSLSocketFactory(sf);
                            httpsConnection.setHostnameVerifier(trustAllNames);
                        }
                    }
                };
            }
            catch (NoSuchAlgorithmException e) {
                log.error("Not Supported", (Throwable)e);
            }
            catch (KeyManagementException e) {
                log.error("Not Supported", (Throwable)e);
            }
        }
        return new ConnectionConfigurator(){

            @Override
            public void process(URLConnection connection) {
            }
        };
    }

    private static interface ConnectionConfigurator {
        public void process(URLConnection var1);
    }
}

