/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.jsonrefparser.resolver;

public enum RefFormat {
    FILE,
    URL,
    CLASSPATH,
    RELATIVE,
    INTERNAL;


    public static RefFormat of(String ref) {
        if (ref.startsWith("file:")) {
            return FILE;
        }
        if (ref.startsWith("classpath:")) {
            return CLASSPATH;
        }
        if (ref.startsWith("http") || ref.startsWith("https")) {
            return URL;
        }
        if (ref.startsWith("#/")) {
            return INTERNAL;
        }
        return RELATIVE;
    }

    public boolean isAnExternalRefFormat() {
        return this == URL || this == RELATIVE || this == CLASSPATH;
    }
}

