/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.jsonrefparser.resolver;

import io.zenwave360.jsonrefparser.$Ref;
import io.zenwave360.jsonrefparser.resolver.Resolver;
import java.io.InputStream;
import java.net.URI;

public class ClasspathResolver
implements Resolver {
    private ClassLoader resourceClassLoader = this.getClass().getClassLoader();

    public ClasspathResolver withResourceClassLoader(ClassLoader resourceClassLoader) {
        if (resourceClassLoader != null) {
            this.resourceClassLoader = resourceClassLoader;
        }
        return this;
    }

    @Override
    public String resolve($Ref $ref) {
        String content = null;
        try {
            InputStream inputStream;
            URI uri = $ref.getURI();
            if (uri.toString().startsWith("classpath:") && !uri.toString().startsWith("classpath:/")) {
                uri = URI.create(uri.toString().replace("classpath:", "classpath:/"));
            }
            if ((inputStream = this.resourceClassLoader.getResourceAsStream(uri.getPath().replaceFirst("^/", ""))) == null) {
                throw new Resolver.MissingResourceException("Resource not found: " + uri, null);
            }
            content = new String(inputStream.readAllBytes());
        }
        catch (Resolver.MissingResourceException missingResourceException) {
            throw missingResourceException;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return content;
    }
}

