/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.jsonrefparser;

import com.jayway.jsonpath.Predicate;
import io.zenwave360.jsonrefparser.$Ref;
import io.zenwave360.jsonrefparser.$RefParserOptions;
import io.zenwave360.jsonrefparser.$Refs;
import io.zenwave360.jsonrefparser.AuthenticationValue;
import io.zenwave360.jsonrefparser.parser.ExtendedJsonContext;
import io.zenwave360.jsonrefparser.parser.Parser;
import io.zenwave360.jsonrefparser.resolver.ClasspathResolver;
import io.zenwave360.jsonrefparser.resolver.FileResolver;
import io.zenwave360.jsonrefparser.resolver.HttpResolver;
import io.zenwave360.jsonrefparser.resolver.RefFormat;
import io.zenwave360.jsonrefparser.resolver.Resolver;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class $RefParser {
    private static final Logger log = LoggerFactory.getLogger($RefParser.class);
    public final File file;
    public final URI uri;
    public final String json;
    private ClassLoader resourceClassLoader;
    public $Refs refs;
    public final Map<RefFormat, Resolver> resolvers = new HashMap<RefFormat, Resolver>();
    private Map<String, ExtendedJsonContext> urlJsonContextCache;
    private List<AuthenticationValue> authenticationValues;
    private $RefParserOptions options;
    private List<Object> visited;
    private List<String> indent;

    public $RefParser(File file) throws MalformedURLException {
        this.resolvers.put(RefFormat.FILE, new FileResolver());
        this.resolvers.put(RefFormat.URL, new HttpResolver());
        this.resolvers.put(RefFormat.CLASSPATH, new ClasspathResolver());
        this.urlJsonContextCache = new HashMap<String, ExtendedJsonContext>();
        this.authenticationValues = new ArrayList<AuthenticationValue>();
        this.visited = new ArrayList<Object>();
        this.indent = new ArrayList<String>();
        this.file = file;
        this.uri = file.toURI();
        this.json = null;
    }

    public $RefParser(URI uri) {
        this.resolvers.put(RefFormat.FILE, new FileResolver());
        this.resolvers.put(RefFormat.URL, new HttpResolver());
        this.resolvers.put(RefFormat.CLASSPATH, new ClasspathResolver());
        this.urlJsonContextCache = new HashMap<String, ExtendedJsonContext>();
        this.authenticationValues = new ArrayList<AuthenticationValue>();
        this.visited = new ArrayList<Object>();
        this.indent = new ArrayList<String>();
        if (uri.toString().startsWith("classpath:") && !uri.toString().startsWith("classpath:/")) {
            uri = URI.create(uri.toString().replace("classpath:", "classpath:/"));
        }
        if (uri.getScheme() == null || uri.getScheme().length() == 1) {
            this.file = new File(uri.toString());
            this.uri = this.file.toURI();
        } else {
            this.uri = uri;
            this.file = null;
        }
        this.json = null;
    }

    public $RefParser(String json) {
        this.resolvers.put(RefFormat.FILE, new FileResolver());
        this.resolvers.put(RefFormat.URL, new HttpResolver());
        this.resolvers.put(RefFormat.CLASSPATH, new ClasspathResolver());
        this.urlJsonContextCache = new HashMap<String, ExtendedJsonContext>();
        this.authenticationValues = new ArrayList<AuthenticationValue>();
        this.visited = new ArrayList<Object>();
        this.indent = new ArrayList<String>();
        this.json = json;
        this.file = null;
        this.uri = null;
    }

    public $RefParser(String json, URI uri) {
        this.resolvers.put(RefFormat.FILE, new FileResolver());
        this.resolvers.put(RefFormat.URL, new HttpResolver());
        this.resolvers.put(RefFormat.CLASSPATH, new ClasspathResolver());
        this.urlJsonContextCache = new HashMap<String, ExtendedJsonContext>();
        this.authenticationValues = new ArrayList<AuthenticationValue>();
        this.visited = new ArrayList<Object>();
        this.indent = new ArrayList<String>();
        this.file = null;
        this.uri = uri;
        this.json = json;
    }

    public $RefParser parse() throws IOException {
        this.refs = this.file != null ? new $Refs(Parser.parse(this.file), this.uri) : (this.uri != null ? new $Refs(Parser.parse(this.uri), this.uri) : new $Refs(Parser.parse(this.json)));
        return this;
    }

    public $RefParser withResourceClassLoader(ClassLoader resourceClassLoader) {
        this.resourceClassLoader = resourceClassLoader;
        Parser.withResourceClassLoader(resourceClassLoader);
        Resolver classpathResolver = this.resolvers.get((Object)RefFormat.CLASSPATH);
        if (classpathResolver instanceof ClasspathResolver) {
            ((ClasspathResolver)classpathResolver).withResourceClassLoader(resourceClassLoader);
        }
        return this;
    }

    public $RefParser withAuthentication(AuthenticationValue authenticationValue) {
        this.authenticationValues.add(authenticationValue);
        this.resolvers.values().forEach(resolver -> resolver.withAuthentication(authenticationValue));
        return this;
    }

    public $RefParser withResolver(RefFormat refFormat, Resolver resolver) {
        this.resolvers.put(refFormat, resolver);
        return this;
    }

    public $RefParser withOptions($RefParserOptions options) {
        this.options = options;
        return this;
    }

    public $Refs getRefs() {
        return this.refs;
    }

    public $RefParser dereference() {
        this.refs.addPath(this.uri);
        this.visited.clear();
        this.dereference(this.refs.jsonContext, this.refs.schema(), new String[0], this.uri);
        return this;
    }

    public $RefParser mergeAllOf() {
        this.refs.addPath(this.uri);
        this.visited.clear();
        this.mergeAllOf(this.refs.schema(), new String[0], this.uri);
        return this;
    }

    private void mergeAllOf(Object value, String[] paths, URI currentFileURL) {
        if (paths.length > 0 && "allOf".equals(paths[paths.length - 1])) {
            List allOf = (List)value;
            AllOfObject allOfObject = new AllOfObject();
            for (int i = 0; i < allOf.size(); ++i) {
                if (!(allOf.get(i) instanceof Map)) {
                    throw new RuntimeException("Could not understand allOf: " + allOf.get(i));
                }
                Map item = (Map)allOf.get(i);
                this.merge(allOfObject, item);
            }
            String[] jsonPaths = Arrays.copyOf(paths, paths.length - 1);
            String jsonPath = this.jsonPath(jsonPaths);
            try {
                Map<String, Object> mergedAllOfObject = allOfObject.buildAllOfObject();
                this.refs.jsonContext.set(jsonPath, mergedAllOfObject, new Predicate[0]);
                this.refs.saveOriginalAllOf(mergedAllOfObject, allOf);
            }
            catch (Exception e2) {
                log.error("Error setting jsonPath:{} in file:{}", new Object[]{jsonPath, currentFileURL, e2});
                throw e2;
            }
        } else if (value instanceof Map) {
            ((Map)value).entrySet().forEach(e -> this.mergeAllOf(e.getValue(), (String[])ArrayUtils.add((Object[])paths, (Object)((String)e.getKey())), currentFileURL));
        } else if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                this.mergeAllOf(list.get(i), (String[])ArrayUtils.add((Object[])paths, (Object)("" + i)), currentFileURL);
            }
        }
    }

    private void merge(AllOfObject allOfObject, List<Map<String, Object>> items) {
        for (Map<String, Object> innerItem : items) {
            this.merge(allOfObject, innerItem);
        }
    }

    private void merge(AllOfObject allOfObject, Map<String, Object> item) {
        if (item.keySet().size() == 1 && item.containsKey("allOf")) {
            List items = (List)item.get("allOf");
            this.merge(allOfObject, items);
        } else {
            allOfObject.allOf.putAll(item);
            if (item.containsKey("properties")) {
                allOfObject.properties.putAll((Map)item.get("properties"));
            }
            if (item.containsKey("required")) {
                allOfObject.required.addAll((List)item.get("required"));
            }
        }
    }

    private String indent() {
        return StringUtils.join(this.indent, (String)"");
    }

    private void dereference(ExtendedJsonContext jsonContext, Object value, String[] paths, URI currentFileURL) {
        String visitedNodeRef = String.format("%s%s", currentFileURL, this.jsonPointer(paths));
        log.trace("{}visiting {}", (Object)this.indent(), (Object)visitedNodeRef);
        if (this.visited.contains(visitedNodeRef)) {
            log.trace("{}skipping visited {}", (Object)this.indent(), (Object)visitedNodeRef);
            return;
        }
        this.visited.add(visitedNodeRef);
        if (paths.length > 0 && "$ref".equals(paths[paths.length - 1])) {
            boolean isCircular;
            $Ref $ref = $Ref.of((String)value, currentFileURL);
            boolean bl = isCircular = (this.jsonPointer(paths) + "/").startsWith($ref.getPath() + "/") && ($ref.getURI() == null || $ref.getURI().equals(currentFileURL));
            if (isCircular) {
                if (this.options != null && $RefParserOptions.OnCircular.FAIL == this.options.onCircular) {
                    throw new RuntimeException("Failing: Circular references not allowed " + $ref);
                }
                if (this.options != null && $RefParserOptions.OnCircular.SKIP == this.options.onCircular) {
                    return;
                }
                this.refs.circular = true;
                boolean isSelfReferencing = this.jsonPointer(paths).equals($ref.getPath() + "/$ref");
                if (isSelfReferencing) {
                    log.debug("{}Skipping self referencing reference [TODO: implement this] {}", (Object)this.indent(), (Object)$ref);
                }
            }
            String[] innerJsonPaths = Arrays.copyOf(paths, paths.length - 1);
            String innerJsonPath = this.jsonPath(innerJsonPaths);
            this.indent.add("->  ");
            log.trace("{}resolving {} for {}", new Object[]{this.indent(), $ref, visitedNodeRef});
            Object resolved = null;
            try {
                resolved = this.dereference($ref, jsonContext, currentFileURL);
            }
            catch (Resolver.MissingResourceException e2) {
                if (this.options != null && $RefParserOptions.OnMissing.SKIP == this.options.onMissing) {
                    log.warn("Skipping missing reference {}", (Object)$ref);
                    return;
                }
                throw e2;
            }
            this.indent.remove(this.indent.size() - 1);
            URI resolvedRefURL = (URI)ObjectUtils.firstNonNull((Object[])new URI[]{$ref.getURI(), currentFileURL});
            String[] resolvedNodePaths = this.jsonPointerToPaths($ref.getPath());
            String resolvedNodeRef = String.format("%s%s", resolvedRefURL, $ref.getPath());
            this.indent.add(" => ");
            log.trace("{}dereferencing resolved {}", (Object)this.indent(), (Object)resolvedNodeRef);
            this.dereference(jsonContext, resolved, resolvedNodePaths, resolvedRefURL);
            this.indent.remove(this.indent.size() - 1);
            try {
                log.trace("{}setting resolved value at {} {}", new Object[]{this.indent(), innerJsonPath, currentFileURL});
                resolved = this.dereference($ref, jsonContext, currentFileURL);
                this.refs.saveOriginalRef($ref, resolved);
                jsonContext.set(innerJsonPath, resolved, new Predicate[0]);
            }
            catch (Exception e3) {
                log.error("Error setting jsonPath: {} in {}", new Object[]{innerJsonPath, currentFileURL, e3});
                throw e3;
            }
        }
        if (value instanceof Map) {
            ((Map)value).entrySet().forEach(e -> this.dereference(jsonContext, e.getValue(), (String[])ArrayUtils.add((Object[])paths, (Object)((String)e.getKey())), currentFileURL));
        } else if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                this.dereference(jsonContext, list.get(i), (String[])ArrayUtils.add((Object[])paths, (Object)("" + i)), currentFileURL);
            }
        }
    }

    private Object dereference($Ref $ref, ExtendedJsonContext jsonContext, URI currentFileURL) {
        Object resolved;
        this.refs.addRef($ref.getRef());
        if ($ref.getRefFormat().isAnExternalRefFormat()) {
            this.refs.addPath($ref.getURI());
            String refUrl = $ref.getURI().toString();
            if (this.urlJsonContextCache.containsKey(refUrl)) {
                jsonContext = this.urlJsonContextCache.get(refUrl);
            } else {
                Resolver resolver = this.getResolver($ref.getRefFormat(), $ref.getURI());
                resolved = resolver.resolve($ref);
                jsonContext = Parser.parse((String)resolved);
                this.urlJsonContextCache.put(refUrl, jsonContext);
                this.refs.addJsonContext($ref.getURI(), jsonContext);
                if (jsonContext.json() instanceof Map || jsonContext.json() instanceof List) {
                    this.dereference(jsonContext, jsonContext.json(), new String[0], $ref.getURI());
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)$ref.getPath())) {
            String[] jsonPaths = $ref.getPath().replace("#/", "").split("/");
            String jsonPath = this.jsonPath(jsonPaths);
            try {
                resolved = jsonContext.read(jsonPath, new Predicate[0]);
                return resolved;
            }
            catch (Exception e) {
                log.error("Error reading internal path: {}", (Object)$ref, (Object)e);
                throw e;
            }
        }
        return jsonContext.json();
    }

    protected Resolver getResolver(RefFormat refFormat, URI currentURL) {
        if (refFormat == RefFormat.RELATIVE) {
            return this.getResolver(RefFormat.of(currentURL.toString()), currentURL);
        }
        return this.resolvers.get((Object)refFormat);
    }

    private String jsonPath(String[] paths) {
        return "$" + Arrays.stream(paths).map(path -> "['" + path + "']").collect(Collectors.joining());
    }

    private String jsonPointer(String[] paths) {
        return "#/" + Arrays.stream(paths).map(path -> path.replace("~", "~0").replace("/", "~1").replace("\\", "\\\\").replace("\"", "\\\"")).collect(Collectors.joining("/"));
    }

    private String[] jsonPointerToPaths(String jsonPointer) {
        if (jsonPointer == null) {
            return new String[0];
        }
        return Arrays.stream(jsonPointer.replaceFirst("^#/", "").split("/")).map(path -> path.replace("~0", "~").replace("~1", "/").replace("\\\\", "\\").replace("\\\"", "\"")).collect(Collectors.toList()).toArray(new String[0]);
    }

    private static class AllOfObject {
        Map<String, Object> allOf = new HashMap<String, Object>();
        Map<String, Object> properties = new HashMap<String, Object>();
        List<String> required = new ArrayList<String>();

        private AllOfObject() {
        }

        Map<String, Object> buildAllOfObject() {
            LinkedHashMap<String, Object> allOfObject = new LinkedHashMap<String, Object>(this.allOf);
            if (!this.required.isEmpty()) {
                allOfObject.put("required", this.required);
            }
            if (!this.properties.isEmpty()) {
                allOfObject.put("properties", this.properties);
            }
            return allOfObject;
        }
    }
}

