/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.jsonrefparser.parser;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import io.zenwave360.jsonrefparser.parser.CustomJacksonJsonProvider;
import io.zenwave360.jsonrefparser.parser.CustomYAMLFactory;
import io.zenwave360.jsonrefparser.parser.ExtendedJsonContext;
import io.zenwave360.jsonrefparser.parser.JsonDeserializerWithLocations;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger log = LoggerFactory.getLogger(Parser.class);
    private static ClassLoader resourceClassLoader = Parser.class.getClassLoader();

    public static void withResourceClassLoader(ClassLoader resourceClassLoader) {
        if (resourceClassLoader != null) {
            Parser.resourceClassLoader = resourceClassLoader;
        }
    }

    public static ExtendedJsonContext parse(URI uri) throws IOException {
        if ("classpath".contentEquals(uri.getScheme())) {
            try (InputStream inputStream = resourceClassLoader.getResourceAsStream(uri.getPath().replaceFirst("^/", ""));){
                ExtendedJsonContext extendedJsonContext = Parser.parse(inputStream, uri);
                return extendedJsonContext;
            }
        }
        try (FileInputStream inputStream = new FileInputStream(new File(uri));){
            ExtendedJsonContext extendedJsonContext = Parser.parse(inputStream, uri);
            return extendedJsonContext;
        }
    }

    public static ExtendedJsonContext parse(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            ExtendedJsonContext extendedJsonContext = Parser.parse(inputStream, file);
            return extendedJsonContext;
        }
    }

    public static ExtendedJsonContext parse(String content) {
        ExtendedJsonContext extendedJsonContext;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        try {
            extendedJsonContext = Parser.parse(inputStream, "string");
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        inputStream.close();
        return extendedJsonContext;
    }

    public static ExtendedJsonContext parse(InputStream inputStream, Object source) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("$RefParser.parse(): InputStream not found [" + source + "]");
        }
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new CustomYAMLFactory());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        JsonDeserializerWithLocations jsonDeserializerWithLocations = new JsonDeserializerWithLocations();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Object.class, (JsonDeserializer)jsonDeserializerWithLocations);
        mapper.registerModule((Module)module);
        Configuration jsonPathConfiguration = new Configuration.ConfigurationBuilder().jsonProvider((JsonProvider)new CustomJacksonJsonProvider(mapper)).mappingProvider((MappingProvider)new JacksonMappingProvider(mapper)).options(EnumSet.noneOf(Option.class)).build();
        String content = new String(inputStream.readAllBytes());
        DocumentContext parsed = JsonPath.parse((String)content, (Configuration)jsonPathConfiguration);
        ExtendedJsonContext.of(parsed, jsonDeserializerWithLocations.getLocations()).toString();
        return ExtendedJsonContext.of(parsed, jsonDeserializerWithLocations.getLocations());
    }
}

