/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.Actions;
import com.intuit.karate.Json;
import com.intuit.karate.KarateException;
import com.intuit.karate.ScenarioActions;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.core.FeatureSection;
import com.intuit.karate.core.MockHandlerHook;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepRuntime;
import com.intuit.karate.core.Variable;
import com.intuit.karate.core.compatibility.KarateCompatibility;
import com.intuit.karate.graal.JsValue;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.Request;
import com.intuit.karate.http.ResourceType;
import com.intuit.karate.http.Response;
import com.intuit.karate.http.ServerHandler;
import com.intuit.karate.resource.Resource;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockHandler
implements ServerHandler {
    private static final Logger logger = LoggerFactory.getLogger(MockHandler.class);
    private static final String REQUEST_BYTES = "requestBytes";
    private static final String REQUEST_PARAMS = "requestParams";
    private static final String REQUEST_PARTS = "requestParts";
    private static final String RESPONSE_DELAY = "responseDelay";
    private static final String PATH_MATCHES = "pathMatches";
    private static final String METHOD_IS = "methodIs";
    private static final String TYPE_CONTAINS = "typeContains";
    private static final String ACCEPT_CONTAINS = "acceptContains";
    private static final String HEADER_CONTAINS = "headerContains";
    private static final String PARAM_VALUE = "paramValue";
    private static final String PARAM_EXISTS = "paramExists";
    private static final String PATH_PARAMS = "pathParams";
    private static final String BODY_PATH = "bodyPath";
    private final List<Feature> featureList;
    private final Map<String, Object> args;
    private final LinkedHashMap<Feature, ScenarioRuntime> features = new LinkedHashMap();
    private final Map<String, Variable> globals = new HashMap<String, Variable>();
    private boolean corsEnabled;
    protected static final ThreadLocal<Request> LOCAL_REQUEST = new ThreadLocal();
    private String prefix = null;
    private List<MockHandlerHook> handlerHooks = new ArrayList<MockHandlerHook>();
    private static final Result PASSED = Result.passed((long)0L);
    private static final String ALLOWED_METHODS = "GET, HEAD, POST, PUT, DELETE, PATCH";

    public MockHandler(Feature feature) {
        this(feature, null);
    }

    public MockHandler(Feature feature, Map<String, Object> args) {
        this(Collections.singletonList(feature), args);
    }

    public MockHandler(List<Feature> features) {
        this(features, null);
    }

    public MockHandler(List<Feature> features, Map<String, Object> args) {
        this.featureList = features;
        this.args = args;
    }

    public MockHandler withPrefix(String prefix) {
        this.prefix = "/".equals(prefix) ? null : prefix;
        return this;
    }

    public MockHandler withHandlerHooks(List<MockHandlerHook> handlerHooks) {
        this.handlerHooks = handlerHooks;
        return this;
    }

    public MockHandler start() {
        this.reload();
        return this;
    }

    private Map<String, Variable> shallowCloneVariables(ScenarioEngine engine) {
        try {
            return engine.shallowCloneVariables();
        }
        catch (Throwable e) {
            try {
                Method method = ScenarioEngine.class.getDeclaredMethod("detachVariables", null);
                method.setAccessible(true);
                return (Map)method.invoke((Object)engine, new Object[0]);
            }
            catch (Exception ex) {
                logger.error("Unknown version of karate, couldn't find ScenarioEngine.shallowCloneVariables() method", (Throwable)ex);
                throw new RuntimeException("Unknown version of karate, couldn't find ScenarioEngine.shallowCloneVariables() method", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        for (MockHandlerHook hook : this.handlerHooks) {
            hook.reload();
        }
        this.featureList.replaceAll(feature -> Feature.read((Resource)feature.getResource()));
        for (Feature feature2 : this.featureList) {
            FeatureRuntime featureRuntime = KarateCompatibility.featureRuntimeOf(feature2, this.args);
            Scenario dummy = MockHandler.createDummyScenario(feature2);
            ScenarioRuntime runtime = new ScenarioRuntime(featureRuntime, dummy);
            this.initRuntime(runtime);
            if (feature2.isBackgroundPresent()) {
                ScenarioEngine prevEngine = ScenarioEngine.get();
                try {
                    ScenarioEngine.set((ScenarioEngine)runtime.engine);
                    for (Step step : feature2.getBackground().getSteps()) {
                        Result result = StepRuntime.execute((Step)step, (Actions)runtime.actions);
                        if (!result.isFailed()) continue;
                        String message = "mock-server background failed - " + feature2 + ":" + step.getLine();
                        runtime.logger.error(message, new Object[0]);
                        throw new KarateException(message, result.getError());
                    }
                }
                finally {
                    ScenarioEngine.set((ScenarioEngine)prevEngine);
                }
            }
            this.corsEnabled = this.corsEnabled || runtime.engine.getConfig().isCorsEnabled();
            this.globals.putAll(this.shallowCloneVariables(runtime.engine));
            runtime.logger.info("mock server initialized: {}", new Object[]{feature2});
            this.features.put(feature2, runtime);
        }
        for (MockHandlerHook hook : this.handlerHooks) {
            hook.onSetup(this.features, this.globals);
        }
    }

    public static Scenario createDummyScenario(Feature feature) {
        FeatureSection section = new FeatureSection();
        section.setIndex(-1);
        Scenario dummy = new Scenario(feature, section, -1);
        section.setScenario(dummy);
        return dummy;
    }

    private void initRuntime(ScenarioRuntime runtime) {
        runtime.engine.setVariable(PATH_MATCHES, this::pathMatches);
        runtime.engine.setVariable(PARAM_EXISTS, this::paramExists);
        runtime.engine.setVariable(PARAM_VALUE, this::paramValue);
        runtime.engine.setVariable(METHOD_IS, this::methodIs);
        runtime.engine.setVariable(TYPE_CONTAINS, this::typeContains);
        runtime.engine.setVariable(ACCEPT_CONTAINS, this::acceptContains);
        runtime.engine.setVariable(HEADER_CONTAINS, this::headerContains);
        runtime.engine.setVariable(BODY_PATH, this::bodyPath);
        runtime.engine.init();
    }

    public synchronized Response handle(Request req) {
        ScenarioRuntime runtime;
        if (this.corsEnabled && "OPTIONS".equals(req.getMethod())) {
            Response response = new Response(200);
            response.setHeader("Allow", new String[]{ALLOWED_METHODS});
            response.setHeader("Access-Control-Allow-Origin", new String[]{"*"});
            response.setHeader("Access-Control-Allow-Methods", new String[]{ALLOWED_METHODS});
            List requestHeaders = req.getHeaderValues("Access-Control-Request-Headers");
            if (requestHeaders != null) {
                response.setHeader("Access-Control-Allow-Headers", requestHeaders);
            }
            return response;
        }
        String path = ("/" + req.getPath()).replaceFirst("^//", "/");
        if (this.prefix != null && path.startsWith(this.prefix)) {
            req.setPath(path.substring(this.prefix.length()));
        }
        ScenarioEngine prevEngine = ScenarioEngine.get();
        for (MockHandlerHook mockHandlerHook : this.handlerHooks) {
            Response response = mockHandlerHook.beforeRequest(req);
            if (response == null) continue;
            logger.info("Returning response on 'beforeRequest' from hook: {}", (Object)mockHandlerHook);
            return response;
        }
        block1: for (Map.Entry entry : this.features.entrySet()) {
            Feature feature = (Feature)entry.getKey();
            runtime = (ScenarioRuntime)entry.getValue();
            Thread.currentThread().setContextClassLoader(runtime.featureRuntime.suite.classLoader);
            LOCAL_REQUEST.set(req);
            req.processBody();
            ScenarioEngine engine = this.createScenarioEngine(req, runtime);
            Map parts = req.getMultiParts();
            if (parts != null) {
                engine.setHiddenVariable(REQUEST_PARTS, (Object)parts);
            }
            for (FeatureSection fs : feature.getSections()) {
                if (fs.isOutline()) {
                    runtime.logger.warn("skipping scenario outline - {}:{}", new Object[]{feature, fs.getScenarioOutline().getLine()});
                    continue block1;
                }
                Scenario scenario = fs.getScenario();
                if (!this.isMatchingScenario(scenario, engine)) continue;
                for (MockHandlerHook hook : this.handlerHooks) {
                    Response response = hook.beforeScenario(req, engine);
                    if (response == null) continue;
                    logger.info("Returning response on 'beforeScenario' from hook: {}", (Object)hook);
                    return response;
                }
                ScenarioActions actions = new ScenarioActions(engine);
                Result result = PASSED;
                result = this.executeScenarioSteps(feature, runtime, scenario, actions, result);
                engine.mockAfterScenario();
                Map configureHeaders = engine.mockConfigureHeaders();
                Variable response = (Variable)engine.vars.remove("response");
                Variable responseStatus = (Variable)engine.vars.remove("responseStatus");
                Variable responseHeaders = (Variable)engine.vars.remove("responseHeaders");
                Variable responseDelay = (Variable)engine.vars.remove(RESPONSE_DELAY);
                this.globals.putAll(this.shallowCloneVariables(engine));
                Response res = new Response(200);
                if (result.isFailed()) {
                    response = new Variable((Object)result.getError().getMessage());
                    responseStatus = new Variable((Object)500);
                } else {
                    if (this.corsEnabled) {
                        res.setHeader("Access-Control-Allow-Origin", new String[]{"*"});
                    }
                    res.setHeaders(configureHeaders);
                    if (responseHeaders != null && responseHeaders.isMap()) {
                        res.setHeaders((Map)responseHeaders.getValue());
                    }
                    if (responseDelay != null) {
                        res.setDelay(responseDelay.getAsInt());
                    }
                }
                if (response != null && !response.isNull()) {
                    ResourceType rt;
                    res.setBody(response.getAsByteArray());
                    if (res.getContentType() == null && (rt = ResourceType.fromObject((Object)response.getValue())) != null) {
                        res.setContentType(rt.contentType);
                    }
                }
                if (responseStatus != null) {
                    res.setStatus(responseStatus.getAsInt());
                }
                if (prevEngine != null) {
                    ScenarioEngine.set((ScenarioEngine)prevEngine);
                }
                if (result.isFailed()) {
                    for (MockHandlerHook hook : this.handlerHooks) {
                        logger.trace("Running 'afterScenarioFailure' from hook: {}", (Object)hook);
                        res = hook.afterScenarioFailure(req, res, engine);
                    }
                } else {
                    for (MockHandlerHook hook : this.handlerHooks) {
                        logger.trace("Running 'afterScenarioSuccess' from hook: {}", (Object)hook);
                        res = hook.afterScenarioSuccess(req, res, engine);
                    }
                }
                return res;
            }
        }
        Response res = new Response(404);
        for (MockHandlerHook hook : this.handlerHooks) {
            logger.info("Returning response on 'noMatchingScenario' from hook: {}", (Object)hook);
            runtime = this.features.values().stream().findFirst().get();
            res = hook.noMatchingScenario(req, res, this.createScenarioEngine(req, runtime));
        }
        logger.warn("no scenarios matched, returning 404: {}", (Object)req);
        if (prevEngine != null) {
            ScenarioEngine.set((ScenarioEngine)prevEngine);
        }
        return res;
    }

    private Result executeScenarioSteps(Feature feature, ScenarioRuntime runtime, Scenario scenario, ScenarioActions actions, Result result) {
        for (Step step : scenario.getSteps()) {
            result = StepRuntime.execute((Step)step, (Actions)actions);
            if (result.isAborted()) {
                runtime.logger.debug("abort at {}:{}", new Object[]{feature, step.getLine()});
                break;
            }
            if (!result.isFailed()) continue;
            String message = "server-side scenario failed, " + feature + ":" + step.getLine() + "\n" + step.toString() + "\n" + result.getError().getMessage();
            runtime.logger.error(message, new Object[0]);
            break;
        }
        return result;
    }

    private ScenarioEngine createScenarioEngine(Request req, ScenarioRuntime runtime) {
        ScenarioEngine engine = KarateCompatibility.newScenarioEngine(runtime, new HashMap<String, Variable>(this.globals));
        ScenarioEngine.set((ScenarioEngine)engine);
        engine.init();
        engine.setVariable("requestUrlBase", (Object)req.getUrlBase());
        engine.setVariable("requestUri", (Object)req.getPath());
        engine.setVariable("requestMethod", (Object)req.getMethod());
        engine.setVariable("requestHeaders", (Object)req.getHeaders());
        engine.setVariable("request", req.getBodyConverted());
        engine.setVariable(REQUEST_PARAMS, (Object)req.getParams());
        engine.setVariable(REQUEST_BYTES, (Object)req.getBody());
        return engine;
    }

    private boolean isMatchingScenario(Scenario scenario, ScenarioEngine engine) {
        String expression = StringUtils.trimToNull((String)(scenario.getName() + scenario.getDescription()));
        if (expression == null) {
            engine.logger.debug("default scenario matched at line: {} - {}", new Object[]{scenario.getLine(), engine.getVariable("requestUri")});
            return true;
        }
        try {
            Variable v = engine.evalJs(expression);
            if (v.isTrue()) {
                engine.logger.debug("scenario matched at {} line {}: {}", new Object[]{scenario.getFeature().getResource().getFile(), scenario.getLine(), expression});
                return true;
            }
            engine.logger.trace("scenario skipped at {} line {}: {}", new Object[]{scenario.getFeature().getResource().getFile(), scenario.getLine(), expression});
            return false;
        }
        catch (Exception e) {
            engine.logger.warn("scenario match evaluation failed at {} line {}: {} - {}", new Object[]{scenario.getFeature().getResource().getFile(), scenario.getLine(), expression, e + ""});
            return false;
        }
    }

    public boolean pathMatches(String pattern) {
        String uri = LOCAL_REQUEST.get().getPath();
        if (uri.equals(pattern)) {
            return true;
        }
        Map pathParams = HttpUtils.parseUriPattern((String)pattern, (String)uri);
        if (pathParams == null) {
            return false;
        }
        ScenarioEngine.get().setVariable(PATH_PARAMS, (Object)pathParams);
        return true;
    }

    public boolean paramExists(String name) {
        Map params = LOCAL_REQUEST.get().getParams();
        return params != null && params.containsKey(name);
    }

    public String paramValue(String name) {
        return LOCAL_REQUEST.get().getParam(name);
    }

    public boolean methodIs(String name) {
        return LOCAL_REQUEST.get().getMethod().equalsIgnoreCase(name);
    }

    public boolean typeContains(String text) {
        String contentType = LOCAL_REQUEST.get().getContentType();
        return contentType != null && contentType.contains(text);
    }

    public boolean acceptContains(String text) {
        String acceptHeader = LOCAL_REQUEST.get().getHeader("Accept");
        return acceptHeader != null && acceptHeader.contains(text);
    }

    public boolean headerContains(String name, String value) {
        List values = LOCAL_REQUEST.get().getHeaderValues(name);
        if (values != null) {
            for (String v : values) {
                if (!v.contains(value)) continue;
                return true;
            }
        }
        return false;
    }

    public Object bodyPath(String path) {
        Object result;
        Object body = LOCAL_REQUEST.get().getBodyConverted();
        if (body == null) {
            return null;
        }
        if (path.startsWith("/")) {
            Variable v = ScenarioEngine.evalXmlPath((Variable)new Variable(body), (String)path);
            if (v.isNotPresent()) {
                return null;
            }
            return JsValue.fromJava((Object)v.getValue());
        }
        Json json = Json.of((Object)body);
        try {
            result = json.get(path);
        }
        catch (Exception e) {
            return null;
        }
        return JsValue.fromJava((Object)result);
    }
}

