/*
 * Decompiled with CFR 0.152.
 */
package io.github.apimock;

import com.intuit.karate.StringUtils;
import com.intuit.karate.resource.ResourceUtils;
import io.github.apimock.MockServer;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class Main
implements Callable<Void> {
    private static final String LOGBACK_CONFIG = "logback.configurationFile";
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"display this help message"})
    boolean help;
    @CommandLine.Option(names={"-o", "--openapi"}, description={"openapi definition file for request/response validation"})
    File openapi;
    @CommandLine.Option(names={"-m", "--mock"}, split=",", description={"one or more karate mock features"})
    List<File> mock;
    @CommandLine.Option(names={"-p", "--port"}, description={"server port (default 8080)"})
    int port = 8080;
    @CommandLine.Option(names={"-P", "--prefix"}, defaultValue="/", description={"server context path (default '/')"})
    String contextPath = "/";
    @CommandLine.Option(names={"-W", "--watch"}, description={"watch (and hot-reload) mock server file for changes"})
    boolean watch;

    public static void main(String ... args) throws Exception {
        String logbackConfig = System.getProperty(LOGBACK_CONFIG);
        if (StringUtils.isBlank((String)logbackConfig)) {
            File logbackXml = ResourceUtils.classPathOrFile((String)"logback.xml");
            File logbackTest = ResourceUtils.classPathOrFile((String)"logback-test.xml");
            if (logbackTest != null) {
                System.setProperty(LOGBACK_CONFIG, "logback-test.xml");
            } else if (logbackXml != null) {
                System.setProperty(LOGBACK_CONFIG, "logback.xml");
            } else {
                System.setProperty(LOGBACK_CONFIG, "logback-apimock.xml");
            }
        }
        Main.resetLoggerConfig();
        CommandLine cmd = new CommandLine((Object)new Main());
        int returnCode = cmd.execute(args);
        Thread.currentThread().join();
        System.exit(returnCode);
    }

    @Override
    public Void call() throws Exception {
        if (this.openapi == null && this.mock == null) {
            CommandLine.usage((Object)this, (PrintStream)System.err);
            return null;
        }
        MockServer server = (MockServer)((Object)MockServer.builder().openapi(this.openapi).features(this.mock).pathPrefix(this.contextPath).watch(this.watch).http(this.port).build());
        return null;
    }

    private static void resetLoggerConfig() {
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        try {
            Method reset = factory.getClass().getDeclaredMethod("reset", new Class[0]);
            reset.invoke((Object)factory, new Object[0]);
            Class<?> clazz = Class.forName("ch.qos.logback.classic.util.ContextInitializer");
            Object temp = clazz.getDeclaredConstructors()[0].newInstance(factory);
            Method autoConfig = clazz.getDeclaredMethod("autoConfig", new Class[0]);
            autoConfig.invoke(temp, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

