/*
 * Decompiled with CFR 0.152.
 */
package io.github.apimock;

import com.intuit.karate.core.MockHandler;
import com.intuit.karate.http.HttpServer;
import com.intuit.karate.http.HttpServerHandler;
import com.intuit.karate.http.Request;
import com.intuit.karate.http.Response;
import com.intuit.karate.http.ServerHandler;
import com.intuit.karate.http.SslContextFactory;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import io.github.apimock.MockServerBuilder;
import io.github.apimock.OpenApiValidator4Karate;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MockServer
extends HttpServer {
    MockServer(ServerBuilder sb) {
        super(sb);
        HttpService httpStopService = (ctx, req) -> {
            logger.debug("received command to stop server: {}", (Object)req.path());
            this.stop();
            return HttpResponse.of((HttpStatus)HttpStatus.ACCEPTED);
        };
        sb.service("/__admin/stop", httpStopService);
    }

    public static URL getURLForClassPathArtifact(String artifactId, String filename) throws IOException {
        Pattern regex = Pattern.compile("\\/" + artifactId + "(\\/|-.+.jar)");
        Enumeration<URL> urls = OpenApiValidator4Karate.class.getClassLoader().getResources(filename);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (!regex.matcher(url.getFile()).find()) continue;
            return url;
        }
        throw new RuntimeException("Resource " + filename + " not found in classpath with artifactId " + artifactId);
    }

    public static URL getURL(String filename) {
        if (filename.startsWith("classpath:")) {
            return OpenApiValidator4Karate.class.getClassLoader().getResource(filename.replaceFirst("classpath:", ""));
        }
        try {
            return new File(filename).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class ReloadingMockHandler
    implements ServerHandler {
        private MockHandler handler;
        private final LinkedHashMap<File, Long> files = new LinkedHashMap();

        public ReloadingMockHandler(MockHandler handler, List<File> files) {
            this.handler = handler;
            for (File f : files) {
                this.files.put(f, f.lastModified());
            }
            logger.debug("watch mode init - {}", files);
        }

        public Response handle(Request request) {
            boolean reload;
            boolean bl = reload = this.files.entrySet().stream().filter(e -> ((File)e.getKey()).lastModified() > (Long)e.getValue()).collect(Collectors.toList()).size() > 0;
            if (reload) {
                logger.debug("Reloading MockHandler...");
                this.files.entrySet().forEach(e -> e.setValue(((File)e.getKey()).lastModified()));
                this.handler.reload();
            }
            return this.handler.handle(request);
        }
    }

    public static class Builder
    extends MockServerBuilder {
        @Override
        public <T> T build() {
            ServerBuilder sb = Server.builder();
            sb.requestTimeoutMillis(0L);
            if (this.ssl) {
                sb.https(this.port);
                SslContextFactory factory = new SslContextFactory();
                factory.setCertFile(this.certFile);
                factory.setKeyFile(this.keyFile);
                factory.build();
                sb.tls(factory.getCertFile(), factory.getKeyFile());
            } else {
                sb.http(this.port);
            }
            MockHandler mockHandler = new MockHandler(this.features, (Map<String, Object>)this.args).withPrefix(this.prefix).withHandlerHooks(this.hooks).start();
            List<File> files = this.features.stream().map(f -> f.getResource().getFile()).collect(Collectors.toList());
            if (this.openapi != null) {
                files.add(this.openapi);
            }
            Object handler = this.watch ? new ReloadingMockHandler(mockHandler, files) : mockHandler;
            HttpServerHandler service = new HttpServerHandler((ServerHandler)handler);
            sb.service("prefix:" + (this.prefix == null ? "/" : this.prefix), (HttpService)service);
            return (T)((Object)new MockServer(sb));
        }
    }
}

