/*
 * Decompiled with CFR 0.152.
 */
package io.github.apimock;

import com.intuit.karate.core.Feature;
import com.intuit.karate.core.MockHandlerHook;
import io.github.apimock.MockServer;
import io.github.apimock.OpenApiExamplesHook;
import io.github.apimock.OpenApiValidator4Karate;
import io.github.apimock.OpenApiValidatorHook;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class MockServerBuilder {
    File openapi;
    List<Feature> features = Arrays.asList(Feature.read((String)"classpath:io/github/apimock/default.feature"));
    int port;
    boolean ssl;
    boolean watch;
    File certFile;
    File keyFile;
    Map<String, Object> args;
    String prefix = null;
    List<MockHandlerHook> hooks = new ArrayList<MockHandlerHook>();

    public MockServerBuilder openapi(File openapi) throws MalformedURLException {
        if (openapi == null) {
            return this;
        }
        this.openapi = openapi;
        OpenApiValidator4Karate openApiValidator = OpenApiValidator4Karate.fromURL(this.openapi.toURI().toURL());
        return this.openapi(openApiValidator);
    }

    public MockServerBuilder openapi(String ... apis) throws Exception {
        URL[] urls = (URL[])Arrays.stream(apis).map(openapi -> MockServer.getURL(openapi)).toArray(URL[]::new);
        return this.openapi(urls);
    }

    public MockServerBuilder openapi(URL ... urls) throws MalformedURLException {
        OpenApiValidator4Karate openApiValidator = OpenApiValidator4Karate.fromURL(urls);
        return this.openapi(openApiValidator);
    }

    public MockServerBuilder openapi(OpenApiValidator4Karate openApiValidator) {
        this.withHook(new OpenApiExamplesHook(openApiValidator));
        this.withHook(new OpenApiValidatorHook(openApiValidator));
        return this;
    }

    public MockServerBuilder features(String ... features) {
        this.features = Arrays.asList(features).stream().map(f -> Feature.read((String)f)).collect(Collectors.toList());
        return this;
    }

    public MockServerBuilder features(List<File> features) {
        if (features == null) {
            return this;
        }
        this.features = features.stream().map(f -> Feature.read((File)f)).collect(Collectors.toList());
        return this;
    }

    public MockServerBuilder watch(boolean value) {
        this.watch = value;
        return this;
    }

    public MockServerBuilder http(int value) {
        this.port = value;
        return this;
    }

    public MockServerBuilder https(int value) {
        this.ssl = true;
        this.port = value;
        return this;
    }

    public MockServerBuilder certFile(File value) {
        this.certFile = value;
        return this;
    }

    public MockServerBuilder keyFile(File value) {
        this.keyFile = value;
        return this;
    }

    public MockServerBuilder pathPrefix(String prefix) {
        this.prefix = prefix != null && !prefix.startsWith("/") ? "/" + prefix : prefix;
        return this;
    }

    public MockServerBuilder withHook(MockHandlerHook hook) {
        this.hooks.add(hook);
        return this;
    }

    public MockServerBuilder args(Map<String, Object> value) {
        this.args = value;
        return this;
    }

    public MockServerBuilder arg(String name, Object value) {
        if (this.args == null) {
            this.args = new HashMap<String, Object>();
        }
        this.args.put(name, value);
        return this;
    }

    public abstract <T> T build();
}

