/*
 * Decompiled with CFR 0.152.
 */
package io.github.apimock;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.openapi4j.core.exception.ResolutionException;
import org.openapi4j.core.model.AuthOption;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.model.v3.OAI3Context;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.core.validation.ValidationException;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.validation.v3.OpenApi3Validator;

public class OpenApi3Parser
extends org.openapi4j.parser.OpenApi3Parser {
    private static final String INVALID_SPEC = "Failed to load spec at '%s'";

    public OpenApi3 parse(URL ... urls) throws ResolutionException, ValidationException {
        return this.parse(urls, null, false);
    }

    public OpenApi3 parse(URL[] urls, List<AuthOption> authOptions, boolean validate) throws ResolutionException, ValidationException {
        OpenApi3 api;
        if (urls.length == 1) {
            return this.parse(urls[0], authOptions, false);
        }
        JsonNode baseDocument = null;
        for (URL url : urls) {
            try {
                OAI3Context context = new OAI3Context(url);
                if (baseDocument == null) {
                    baseDocument = context.getBaseDocument();
                    continue;
                }
                baseDocument = this.merge(baseDocument, context.getBaseDocument());
            }
            catch (IllegalArgumentException e) {
                throw new ResolutionException(String.format(INVALID_SPEC, url.toString()), (Throwable)e);
            }
        }
        URL url = urls[0];
        try {
            OAI3Context context = new OAI3Context(url);
            api = (OpenApi3)TreeUtil.json.convertValue(baseDocument, OpenApi3.class);
            api.setContext((OAIContext)context);
        }
        catch (IllegalArgumentException e) {
            throw new ResolutionException(String.format(INVALID_SPEC, url.toString()), (Throwable)e);
        }
        if (validate) {
            OpenApi3Validator.instance().validate(api);
        }
        return api;
    }

    protected JsonNode merge(JsonNode mainNode, JsonNode updateNode) {
        Iterator fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode jsonNode = mainNode.get(fieldName);
            if (jsonNode != null && jsonNode.isObject()) {
                this.merge(jsonNode, updateNode.get(fieldName));
                continue;
            }
            if (!(mainNode instanceof ObjectNode)) continue;
            JsonNode value = updateNode.get(fieldName);
            ((ObjectNode)mainNode).put(fieldName, value);
        }
        return mainNode;
    }
}

