/*
 * Decompiled with CFR 0.152.
 */
package io.github.apimock;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intuit.karate.Json;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.MockHandlerHook;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.core.Variable;
import com.intuit.karate.core.compatibility.KarateCompatibility;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.Request;
import io.github.apimock.OpenApiValidator4Karate;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.parser.model.v3.Example;
import org.openapi4j.parser.model.v3.MediaType;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.model.v3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiExamplesHook
implements MockHandlerHook {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final OpenApiValidator4Karate openApiValidator;
    private OpenApi3 api;
    private ObjectMapper jacksonMapper = new ObjectMapper();
    Pattern generatorsPattern = Pattern.compile("\\{\\{(.+)\\}\\}");
    private int sequenceNext = 0;
    private static final String UUID = "uuid";
    private static final String SEQUENCE_NEXT = "sequenceNext";
    private static final String NOW = "now";
    private static final String DATE = "date";

    public OpenApiExamplesHook(OpenApiValidator4Karate openApiValidator) {
        this.openApiValidator = openApiValidator;
        this.api = openApiValidator.getApi();
    }

    @Override
    public void reload() {
        this.openApiValidator.reload();
        this.api = this.openApiValidator.getApi();
        this.sequenceNext = 0;
    }

    @Override
    public void onSetup(Map<Feature, ScenarioRuntime> features, Map<String, Variable> globals) {
        if (!globals.containsKey(UUID)) {
            globals.put(UUID, new Variable(this::uuid));
        }
        if (!globals.containsKey(SEQUENCE_NEXT)) {
            globals.put(SEQUENCE_NEXT, new Variable(this::sequenceNext));
        }
        if (!globals.containsKey(NOW)) {
            globals.put(NOW, new Variable(this::now));
        }
        if (!globals.containsKey(DATE)) {
            globals.put(DATE, new Variable(this::date));
        }
        if (this.api.getComponents() != null && this.api.getComponents().getExamples() != null) {
            ScenarioEngine engine = KarateCompatibility.newScenarioEngine(features.values().stream().findFirst().get(), new HashMap<String, Variable>(globals));
            engine.init();
            for (Example example : this.api.getComponents().getExamples().values()) {
                String karateVar = (String)this.firstNotNull(example.getExtensions(), Collections.emptyMap()).get("x-apimock-karate-var");
                if (!this.isNotEmpty(karateVar)) continue;
                Integer seeds = this.firstNotNull(this.firstNotNull(example.getExtensions(), Collections.emptyMap()).get("x-apimock-seed"), 1);
                Map<String, Object> seedsMap = seeds instanceof Integer ? this.defaultRootSeed(seeds) : (Map<String, Object>)((Object)seeds);
                Object seededExample = this.seed(example.getValue(), seedsMap);
                try {
                    Map transforms = (Map)this.firstNotNull(example.getExtensions(), Collections.emptyMap()).get("x-apimock-transform");
                    String json = this.processObjectDynamicProperties(engine, transforms, seededExample);
                    Variable exampleVariable = new Variable(Json.of((Object)json).value());
                    this.addExamplesVariableToKarateGlobals(globals, karateVar, exampleVariable);
                }
                catch (Exception e) {
                    this.logger.error("Error setting openapi examples {} into karate globals ({})", new Object[]{karateVar, e.getMessage(), e});
                }
            }
        }
    }

    private Map<String, Object> defaultRootSeed(Integer seed) {
        HashMap<String, Object> seedMap = new HashMap<String, Object>();
        seedMap.put("$", seed);
        return seedMap;
    }

    private Object seed(Object value, Map<String, Object> seedsMap) {
        Json json = Json.of((Object)value);
        for (Map.Entry<String, Object> seedEntry : seedsMap.entrySet()) {
            int seed = (Integer)seedEntry.getValue();
            if (seed == 1) continue;
            String seedPath = String.valueOf(seedEntry.getKey());
            Object inner = json.get(seedPath);
            List seeded = this.seedValue(inner, seed);
            json = this.replace(json, seedPath, seeded);
        }
        return json.get("$");
    }

    private List seedValue(Object value, int seed) {
        ArrayList<Object> seeded = new ArrayList<Object>();
        for (int i = 0; i < seed; ++i) {
            if (value instanceof List) {
                seeded.addAll((List)JsonUtils.deepCopy((Object)value));
                continue;
            }
            seeded.add(JsonUtils.deepCopy((Object)value));
        }
        return seeded;
    }

    private Json replace(Json json, String path, Object replacement) {
        if ("$".equals(path)) {
            return Json.of((Object)replacement);
        }
        json.set(path, replacement);
        return json;
    }

    private void addExamplesVariableToKarateGlobals(Map<String, Variable> globals, String karateVar, Variable examplesVariable) {
        if (!globals.containsKey(karateVar)) {
            globals.put(karateVar, examplesVariable);
        } else {
            Variable karateVariable = globals.get(karateVar);
            if (karateVariable.isList()) {
                if (examplesVariable.isList()) {
                    ((List)karateVariable.getValue()).addAll((Collection)examplesVariable.getValue());
                } else {
                    ((List)karateVariable.getValue()).add(examplesVariable.getValue());
                }
            }
            if (karateVariable.isMap() && examplesVariable.isMap()) {
                ((Map)karateVariable.getValue()).putAll((Map)examplesVariable.getValue());
            }
        }
    }

    @Override
    public com.intuit.karate.http.Response noMatchingScenario(Request req, com.intuit.karate.http.Response response, ScenarioEngine engine) {
        Operation operation = OpenApiValidator4Karate.findOperation(req.getMethod(), req.getPath(), this.api);
        if (operation == null) {
            this.logger.debug("Operation not found for {}", (Object)req.getPath());
            return response;
        }
        this.logger.debug("Searching examples in openapi definition for operationId {}", (Object)operation.getOperationId());
        Map<String, Response> responses = OpenApiValidator4Karate.find2xxResponses(operation);
        this.loadPathParams(req.getPath(), (String)operation.getExtensions().get("x-apimock-internal-path"), engine);
        if (!responses.isEmpty()) {
            String status = (String)responses.keySet().stream().findFirst().get();
            Response oasRespose = responses.get(status);
            String contentType = this.getContentType(req);
            Map.Entry mediaTypeEntry = oasRespose.getContentMediaTypes().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(contentType)).findFirst().orElse(new AbstractMap.SimpleEntry<String, MediaType>("", new MediaType()));
            if (((MediaType)mediaTypeEntry.getValue()).getExamples() == null && ((MediaType)mediaTypeEntry.getValue()).getExample() != null) {
                this.logger.debug("Returning default example in openapi for operationId {}", (Object)operation.getOperationId());
                response = new com.intuit.karate.http.Response(Integer.valueOf(status.toLowerCase().replaceAll("x", "0")).intValue());
                response.setBody(this.processObjectDynamicProperties(engine, null, ((MediaType)mediaTypeEntry.getValue()).getExample()));
                response.setContentType((String)mediaTypeEntry.getKey());
                response.setHeader("access-control-allow-origin", new String[]{"*"});
                this.unloadPathParams(engine);
                return response;
            }
            for (Map.Entry exampleEntry : ((MediaType)mediaTypeEntry.getValue()).getExamples().entrySet()) {
                Map extensions = ((Example)exampleEntry.getValue()).getExtensions();
                if (extensions == null) continue;
                Object when = extensions.get("x-apimock-when");
                Map generators = (Map)extensions.get("x-apimock-transform");
                if (when == null || !this.evalBooleanJs(engine, when.toString())) continue;
                this.logger.debug("Found example[{}] for x-apimock-when {} in openapi for operationId {}", new Object[]{exampleEntry.getKey(), when, operation.getOperationId()});
                Example example = (Example)exampleEntry.getValue();
                Integer seeds = this.firstNotNull(this.firstNotNull(example.getExtensions(), Collections.emptyMap()).get("x-apimock-seed"), 1);
                Map<String, Object> seedsMap = seeds instanceof Integer ? this.defaultRootSeed(seeds) : (Map<String, Object>)((Object)seeds);
                Object seededExample = this.seed(example.getValue(), seedsMap);
                this.logger.debug("Returning example in openapi for operationId {}", (Object)operation.getOperationId());
                response = new com.intuit.karate.http.Response(Integer.valueOf(status.toLowerCase().replaceAll("x", "0")).intValue());
                response.setBody(this.processObjectDynamicProperties(engine, generators, seededExample));
                response.setContentType((String)mediaTypeEntry.getKey());
                response.setHeader("access-control-allow-origin", new String[]{"*"});
                break;
            }
        }
        this.unloadPathParams(engine);
        return response;
    }

    private String getContentType(Request req) {
        String contentType = this.firstNotNull(req.getContentType(), "application/json");
        return contentType.contains(";") ? contentType.substring(0, contentType.indexOf(";")) : contentType;
    }

    protected void evaluateJsAndReplacePath(ScenarioEngine engine, Json json, String path, String js) {
        Object replacement = this.evalJsAsObject(engine, js);
        try {
            if (replacement != null) {
                json.set(path, replacement);
            }
        }
        catch (Exception e) {
            this.logger.error("Error replacing jsonPath: {} ({})", (Object)path, (Object)e.getMessage());
        }
    }

    protected String processObjectDynamicProperties(ScenarioEngine engine, Map<String, String> generators, Object value) {
        if (value == null) {
            return null;
        }
        Json json = Json.of((Object)value);
        if (generators != null) {
            for (Map.Entry<String, String> entry : generators.entrySet()) {
                if (entry.getKey().startsWith("$[*]") && json.isArray()) {
                    List list = json.asList();
                    for (int i = 0; i < list.size(); ++i) {
                        this.evaluateJsAndReplacePath(engine, json, entry.getKey().replace("$[*]", "$[" + i + "]"), entry.getValue());
                    }
                    continue;
                }
                this.evaluateJsAndReplacePath(engine, json, entry.getKey(), entry.getValue());
            }
        }
        String jsonString = this.toJsonPrettyString(json);
        Matcher matcher = this.generatorsPattern.matcher(jsonString);
        while (matcher.find()) {
            String match = matcher.group(0);
            String script = matcher.group(1);
            this.logger.trace("Processing inline replacement for script: {}", (Object)script);
            String replacement = this.evalJsAsString(engine, script);
            if (replacement == null) continue;
            jsonString = jsonString.replace(match, replacement);
        }
        return JsonUtils.toStrictJson((String)jsonString);
    }

    private String toJsonPrettyString(Json json) {
        try {
            return this.jacksonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(json.value());
        }
        catch (JsonProcessingException e) {
            return json.toStringPretty();
        }
    }

    private void loadPathParams(String uri, String pattern, ScenarioEngine engine) {
        Map pathParams = HttpUtils.parseUriPattern((String)pattern, (String)uri);
        if (pathParams != null) {
            engine.setVariable("pathParams", (Object)pathParams);
        }
    }

    private void unloadPathParams(ScenarioEngine engine) {
        engine.setVariable("pathParams", null);
    }

    private boolean evalBooleanJs(ScenarioEngine engine, String js) {
        try {
            return engine.evalJs(js).isTrue();
        }
        catch (Exception e) {
            this.logger.error("Error evaluating boolean script: '{}' ({})", (Object)js, (Object)e.getMessage());
            return false;
        }
    }

    private String evalJsAsString(ScenarioEngine engine, String js) {
        try {
            return engine.evalJs(js).getAsString();
        }
        catch (Exception e) {
            this.logger.error("Error evaluating string script: '{}' ({})", (Object)js, (Object)e.getMessage());
            return null;
        }
    }

    private Object evalJsAsObject(ScenarioEngine engine, String js) {
        try {
            Object result = engine.evalJs(js).getValue();
            return result != null ? result : "";
        }
        catch (Exception e) {
            this.logger.error("Error evaluating script: '{}' ({})", (Object)js, (Object)e.getMessage());
            return null;
        }
    }

    private String uuid() {
        return java.util.UUID.randomUUID().toString();
    }

    private int sequenceNext() {
        return this.sequenceNext++;
    }

    private String now(String format) {
        Date now = new Date();
        return new SimpleDateFormat(format).format(now);
    }

    private String date(String format, String intervalExpression) {
        int length = intervalExpression.length();
        String intervalString = intervalExpression.trim().substring(0, length - 1);
        String range = intervalExpression.trim().substring(length);
        int amount = Integer.parseInt(intervalString);
        int field = 5;
        if (range.equalsIgnoreCase("d")) {
            field = 5;
        }
        if (range.equalsIgnoreCase("h")) {
            field = 10;
        }
        if (range.equalsIgnoreCase("s")) {
            field = 13;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        calendar.add(field, amount);
        return new SimpleDateFormat(format).format(calendar.getTime());
    }

    private <T> T firstNotNull(T one, T two) {
        return one != null ? one : two;
    }

    private boolean isNotEmpty(String str) {
        return str != null && !str.trim().equals("");
    }
}

