/*
 * Decompiled with CFR 0.152.
 */
package io.github.apimock;

import com.intuit.karate.StringUtils;
import com.intuit.karate.http.HttpUtils;
import io.github.apimock.OpenApi3Parser;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openapi4j.core.exception.ResolutionException;
import org.openapi4j.core.validation.ValidationException;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.operation.validator.model.Request;
import org.openapi4j.operation.validator.model.impl.Body;
import org.openapi4j.operation.validator.model.impl.DefaultRequest;
import org.openapi4j.operation.validator.model.impl.DefaultResponse;
import org.openapi4j.operation.validator.validation.RequestValidator;
import org.openapi4j.parser.model.v3.MediaType;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.model.v3.Path;
import org.openapi4j.parser.model.v3.Response;
import org.openapi4j.parser.model.v3.Server;
import org.openapi4j.schema.validator.ValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiValidator4Karate {
    private static Logger logger = LoggerFactory.getLogger(OpenApiValidator4Karate.class);
    private OpenApi3 api;
    private RequestValidator validator;
    private boolean ignoreNoNullable = true;

    public OpenApiValidator4Karate(OpenApi3 api) {
        this.api = api;
        if (this.api.getServers() == null) {
            this.api.setServers(new ArrayList());
        }
        this.api.getServers().add(new Server().setUrl("http://localhost"));
        ValidationContext vdc = new ValidationContext(api.getContext());
        vdc.setOption((byte)1, true);
        vdc.setFastFail(false);
        this.validator = new RequestValidator(vdc, api);
    }

    public static OpenApiValidator4Karate fromURL(URL ... urls) {
        try {
            OpenApi3 api = new OpenApi3Parser().parse(urls);
            if (api.getExtensions() == null) {
                api.setExtensions(new HashMap());
            }
            api.getExtensions().put("x-apimock-internal-urls", urls);
            return new OpenApiValidator4Karate(api);
        }
        catch (ResolutionException | ValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public void reload() {
        URL[] urls = (URL[])this.api.getExtensions().get("x-apimock-internal-urls");
        logger.debug("Loading {} from {}", (Object)this.getClass().getSimpleName(), (Object)urls);
        if (urls != null) {
            OpenApiValidator4Karate reloaded = OpenApiValidator4Karate.fromURL(urls);
            this.api = reloaded.api;
            this.validator = reloaded.validator;
            this.ignoreNoNullable = reloaded.ignoreNoNullable;
        }
    }

    public static Operation findOperation(String method, String requestPath, OpenApi3 api) {
        Operation operation;
        List paths = api.getPaths().entrySet().stream().filter(e -> HttpUtils.parseUriPattern((String)((String)e.getKey()), (String)requestPath) != null || HttpUtils.parseUriPattern((String)((String)e.getKey()), (String)("/" + requestPath)) != null).collect(Collectors.toList());
        Path path = paths.size() == 1 ? (Path)((Map.Entry)paths.get(0)).getValue() : (Path)paths.stream().filter(e -> ((String)e.getKey()).equals(requestPath) || ((String)e.getKey()).equals(OpenApiValidator4Karate.fixUrl(requestPath))).map(e -> (Path)e.getValue()).findFirst().orElse(null);
        Operation operation2 = operation = path != null ? path.getOperation(method.toLowerCase()) : null;
        if (operation != null) {
            if (operation.getExtensions() == null) {
                operation.setExtensions(new HashMap());
            }
            operation.getExtensions().put("x-apimock-internal-path", ((Map.Entry)paths.get(0)).getKey());
        }
        return operation;
    }

    public static Map<String, Response> find2xxResponses(Operation operation) {
        return operation.getResponses().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("2")).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Response)e.getValue()));
    }

    public static Map<String, Collection<String>> cast(Map responseHeaders) {
        return responseHeaders;
    }

    public OpenApi3 getApi() {
        return this.api;
    }

    public ValidationResults isValidRequest(String url, String method, String requestBody, Map<String, Collection<String>> requestHeaders, String operationId) {
        Operation operation = this.api.getOperationById(operationId);
        ValidationResults results = new ValidationResults();
        DefaultRequest request = new DefaultRequest.Builder(OpenApiValidator4Karate.fixUrl(url), Request.Method.getMethod((String)method)).headers(requestHeaders).body(requestBody != null ? Body.from((String)requestBody) : null).build();
        Path path = this.api.getPathItemByOperationId(operationId);
        try {
            this.validator.validate((Request)request, path, operation);
        }
        catch (ValidationException e) {
            for (ValidationResults.ValidationItem item : e.results().items()) {
                if (Integer.valueOf(1021).equals(item.code()) && this.ignoreNoNullable) continue;
                results.add(item);
            }
        }
        return results;
    }

    public ValidationResults isValidResponse(String responseBody, Map<String, Collection<String>> responseHeaders, String operationId, int status) {
        ValidationResults results = new ValidationResults();
        DefaultResponse response = new DefaultResponse.Builder(status).headers(responseHeaders).body(responseBody != null ? Body.from((String)responseBody) : null).build();
        Path path = this.api.getPathItemByOperationId(operationId);
        Operation operation = this.api.getOperationById(operationId);
        if (operation.getResponse(String.valueOf(status)) == null) {
            results.add(String.format("Status code %s not found for operationId %s", status, operationId));
            return results;
        }
        Map<String, MediaType> mediaTypes = this.getMediaTypes(operation, response.getStatus());
        if (mediaTypes == null || mediaTypes.isEmpty()) {
            return results;
        }
        try {
            this.validator.validate((org.openapi4j.operation.validator.model.Response)response, path, operation);
        }
        catch (ValidationException e) {
            for (ValidationResults.ValidationItem item : e.results().items()) {
                if (Integer.valueOf(1021).equals(item.code()) && this.ignoreNoNullable) continue;
                results.add(item);
            }
        }
        return results;
    }

    protected Map<String, MediaType> getMediaTypes(Operation operation, int status) {
        Response response = operation.getResponse(String.valueOf(status));
        if (response.getRef() != null) {
            response = this.api.getComponents().getResponse(response.getRef().substring(response.getRef().lastIndexOf(47) + 1));
        }
        return response.getContentMediaTypes();
    }

    private static String fixUrl(String url) {
        url = url.startsWith("/") ? url : "/" + url;
        try {
            return URLEncoder.encode(url, "UTF8").replaceAll("%2F", "/");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UnsupportedEncodingException UTF8 encoding request path", (Throwable)e);
            return url;
        }
    }

    public static class ValidationResults {
        final List<StringUtils.Pair> items = new ArrayList<StringUtils.Pair>();

        public boolean isValid() {
            return this.items.isEmpty();
        }

        void add(ValidationResults.ValidationItem item) {
            this.items.add(new StringUtils.Pair(item.dataCrumbs(), item.message()));
        }

        void add(String message) {
            this.items.add(new StringUtils.Pair("", message));
        }
    }
}

