/*
 * Decompiled with CFR 0.152.
 */
package io.github.apimock;

import com.intuit.karate.JsonUtils;
import com.intuit.karate.core.MockHandlerHook;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.http.Request;
import com.intuit.karate.http.Response;
import io.github.apimock.OpenApiValidator4Karate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiValidatorHook
implements MockHandlerHook {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final OpenApiValidator4Karate openApiValidator;
    private OpenApi3 api;

    public OpenApiValidatorHook(OpenApiValidator4Karate openApiValidator) {
        this.openApiValidator = openApiValidator;
        this.api = openApiValidator.getApi();
    }

    @Override
    public void reload() {
        this.openApiValidator.reload();
        this.api = this.openApiValidator.getApi();
    }

    @Override
    public Response beforeRequest(Request request) {
        Operation operation = OpenApiValidator4Karate.findOperation(request.getMethod(), request.getPath(), this.api);
        if (operation != null) {
            this.logger.debug("Validating request for operationId {}", (Object)operation.getOperationId());
            OpenApiValidator4Karate.ValidationResults validationResults = this.openApiValidator.isValidRequest(request.getPath(), request.getMethod(), request.getBodyAsString(), OpenApiValidator4Karate.cast(request.getHeaders()), operation.getOperationId());
            if (!validationResults.isValid()) {
                Response response = new Response(400);
                response.setContentType("application/json");
                response.setHeader("access-control-allow-origin", new String[]{"*"});
                response.setBody(this.toJson("request", validationResults));
                return response;
            }
        } else {
            this.logger.warn("OperationId not found in openapi definition for " + request.getMethod() + " " + request.getPath());
        }
        return null;
    }

    @Override
    public Response afterScenarioSuccess(Request request, Response response, ScenarioEngine engine) {
        Operation operation = OpenApiValidator4Karate.findOperation(request.getMethod(), request.getPath(), this.api);
        if (operation != null) {
            this.logger.debug("Validating response for operationId {}", (Object)operation.getOperationId());
            OpenApiValidator4Karate.ValidationResults validationResults = this.openApiValidator.isValidResponse(response.getBodyAsString(), OpenApiValidator4Karate.cast(response.getHeaders()), operation.getOperationId(), response.getStatus());
            if (!validationResults.isValid()) {
                response.setStatus(400);
                response.setContentType("application/json");
                response.setHeader("access-control-allow-origin", new String[]{"*"});
                response.setBody(this.toJson("response", validationResults));
            }
        } else {
            this.logger.warn("OperationId not found in openapi definition for " + request.getMethod() + " " + request.getPath());
        }
        return response;
    }

    public String toJson(String type, OpenApiValidator4Karate.ValidationResults validationResults) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", type);
        HashMap validations = new HashMap();
        validationResults.items.forEach(item -> {
            if (!validations.containsKey(item.left)) {
                validations.put(item.left, new ArrayList());
            }
            ((List)validations.get(item.left)).add(item.right);
        });
        map.put("errors", validations);
        return JsonUtils.toJson(map);
    }
}

