/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.zenwave360.sdk.MainGenerator;
import io.zenwave360.sdk.Plugin;
import io.zenwave360.sdk.doc.DocumentedOption;
import io.zenwave360.sdk.doc.DocumentedPlugin;
import io.zenwave360.sdk.generators.Generator;
import io.zenwave360.sdk.templating.HandlebarsEngine;
import io.zenwave360.sdk.templating.TemplateInput;
import io.zenwave360.sdk.utils.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.reflections.Reflections;

public class Help {
    private ObjectMapper objectMapper = new ObjectMapper();
    private HandlebarsEngine handlebarsEngine = new HandlebarsEngine();

    protected Map<String, Object> buildHelpModel(Plugin configuration) {
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Map<String, Object>> options = new LinkedHashMap<String, Map<String, Object>>();
        LinkedHashMap undocumentedOptions = new LinkedHashMap();
        LinkedHashMap<Class, Map<String, Object>> pluginList = new LinkedHashMap<Class, Map<String, Object>>();
        model.put("configClassName", configuration.getClass().getName());
        DocumentedPlugin pluginDocumentation = configuration.getClass().getAnnotation(DocumentedPlugin.class);
        if (pluginDocumentation != null) {
            model.put("plugin", Maps.of("title", pluginDocumentation.value(), "description", pluginDocumentation.description(), "shortCode", pluginDocumentation.shortCode()));
        }
        model.put("version", this.getClass().getPackage().getImplementationVersion());
        model.put("config", configuration);
        model.put("options", options);
        model.put("undocumentedOptions", undocumentedOptions);
        model.put("pluginChain", pluginList);
        for (Field field : FieldUtils.getAllFields(configuration.getClass())) {
            DocumentedOption documentedOption = field.getAnnotation(DocumentedOption.class);
            if (documentedOption == null) continue;
            options.put(field.getName(), this.asModel(configuration, field, documentedOption));
        }
        List<String> hiddenOptions = Arrays.asList(pluginDocumentation.hiddenOptions());
        int chainIndex = 0;
        for (Class pluginClass : configuration.getChain()) {
            Object plugin;
            try {
                plugin = pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                MainGenerator.applyConfiguration(chainIndex++, plugin, configuration);
                pluginList.put(pluginClass, Generator.asConfigurationMap(plugin));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            for (Field field : FieldUtils.getAllFields((Class)pluginClass)) {
                DocumentedOption documentedOption = field.getAnnotation(DocumentedOption.class);
                if (documentedOption != null && !hiddenOptions.contains(field.getName())) {
                    options.put(field.getName(), this.asModel(plugin, field, documentedOption));
                    continue;
                }
                if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                undocumentedOptions.put(field.getName(), Map.of("name", field.getName(), "ownerClass", pluginClass.getName(), "type", field.getType()));
            }
        }
        return model;
    }

    protected Map<String, Object> discoverAvailablePlugins() {
        ArrayList<Map<String, Object>> plugins = new ArrayList<Map<String, Object>>();
        Set allConfigClasses = new Reflections(new Object[]{"io", "com", "org"}).getSubTypesOf(Plugin.class);
        for (Class pluginClass : allConfigClasses) {
            try {
                plugins.add(this.buildHelpModel(Plugin.of(pluginClass.getName())));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Maps.of("plugins", plugins, new Object[0]);
    }

    protected Map<String, Object> asModel(Object plugin, Field field, DocumentedOption documentedOption) {
        Class<?> type = field.getType();
        ArrayList values = new ArrayList();
        if (type.isEnum()) {
            values.addAll(Arrays.stream(type.getEnumConstants()).map(v -> v.toString()).collect(Collectors.toList()));
        }
        List<Object> defaultValue = null;
        try {
            defaultValue = FieldUtils.readField((Field)field, (Object)plugin, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        List<Object> list = defaultValue = defaultValue == null ? documentedOption.defaultValue() : defaultValue;
        if (defaultValue.getClass().isArray()) {
            defaultValue = Arrays.asList((Object[])defaultValue);
        }
        return Map.of("description", documentedOption.description(), "type", type.getSimpleName(), "defaultValue", defaultValue, "values", values);
    }

    public String help(Plugin plugin, Format format) {
        format = format == null ? Format.help : format;
        Map<String, Object> model = plugin == null ? this.discoverAvailablePlugins() : this.buildHelpModel(plugin);
        model.put("version", this.getClass().getPackage().getImplementationVersion());
        if (format == Format.json) {
            try {
                return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(model);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        String template = "io/zenwave360/sdk/help/" + format.toString();
        return this.handlebarsEngine.processTemplate(model, new TemplateInput().withTemplateLocation(template).withTargetFile("")).get(0).getContent();
    }

    static enum Format {
        list,
        help,
        detailed,
        json,
        markdown,
        html;

    }
}

