/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk;

import io.zenwave360.sdk.Help;
import io.zenwave360.sdk.MainGenerator;
import io.zenwave360.sdk.Plugin;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class Main
implements Callable<Integer> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @CommandLine.Option(names={"-h", "--help"}, arity="0..1", description={"Help with output format"}, converter={HelpFormatConverter.class})
    Help.Format helpFormat;
    @CommandLine.Option(names={"-p", "--plugin"}, arity="0..1", description={"Plugin Class or short-code"})
    String pluginClass;
    @CommandLine.Option(names={"-f", "--force"}, description={"Force overwrite"}, defaultValue="false")
    boolean forceOverwrite = false;
    @CommandLine.Parameters
    Map<String, Object> options = new HashMap<String, Object>();

    public static void main(String ... args) {
        boolean usage;
        Main main = new Main();
        CommandLine cmd = new CommandLine((Object)main);
        CommandLine.ParseResult parsed = cmd.parseArgs(args);
        boolean noOptions = !parsed.hasMatchedOption("h") && !parsed.hasMatchedOption("p");
        boolean noPlugin = !parsed.hasMatchedOption("p");
        boolean bl = usage = parsed.hasMatchedOption("h") && !parsed.hasMatchedOption("p") && main.helpFormat == null;
        if (main.helpFormat == Help.Format.json && !parsed.hasMatchedOption("p")) {
            main.help();
            return;
        }
        if (usage || noOptions || noPlugin) {
            cmd.usage(System.out);
            main.helpFormat = Help.Format.list;
            main.help();
            return;
        }
        if (parsed.hasMatchedOption("h") && parsed.hasMatchedOption("p")) {
            main.help();
            return;
        }
        int returnCode = cmd.execute(args);
        if (returnCode != 0) {
            System.exit(returnCode);
        }
    }

    @Override
    public Integer call() throws Exception {
        if (this.forceOverwrite) {
            this.options.put("forceOverwrite", true);
        }
        Plugin plugin = Plugin.of(this.pluginClass).withSpecFile((String)this.options.get("specFile")).withTargetFolder((String)this.options.get("targetFolder")).withForceOverwrite(this.forceOverwrite).withOptions(this.options);
        new MainGenerator().generate(plugin);
        return 0;
    }

    public void help() {
        try {
            Plugin plugin = null;
            if (StringUtils.isNotBlank((CharSequence)this.pluginClass)) {
                plugin = Plugin.of(this.pluginClass).withSpecFile((String)this.options.get("specFile")).withTargetFolder((String)this.options.get("targetFolder")).withOptions(this.options);
            }
            String help = new Help().help(plugin, this.helpFormat);
            System.out.println(help);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class HelpFormatConverter
    implements CommandLine.ITypeConverter<Help.Format> {
        private HelpFormatConverter() {
        }

        public Help.Format convert(String value) throws Exception {
            if (value == null || value.isEmpty()) {
                return null;
            }
            return Help.Format.valueOf(value);
        }
    }
}

