/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import io.zenwave360.sdk.Plugin;
import io.zenwave360.sdk.formatters.Formatter;
import io.zenwave360.sdk.generators.Generator;
import io.zenwave360.sdk.parsers.Parser;
import io.zenwave360.sdk.processors.Processor;
import io.zenwave360.sdk.templating.TemplateOutput;
import io.zenwave360.sdk.utils.CommaSeparatedCollectionDeserializationHandler;
import io.zenwave360.sdk.writers.TemplateWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainGenerator {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void generate(Plugin configuration) throws Exception {
        this.log.debug("Executing 'generate' with config Options {}", configuration.getOptions());
        this.log.debug("Processed Options {}", configuration.processOptions());
        this.log.debug("Processors chain is {}", configuration.getChain().stream().map(c -> c.getName()).collect(Collectors.toList()));
        Map<String, Object> model = new HashMap<String, Object>();
        List<TemplateOutput> templateOutputList = new ArrayList<TemplateOutput>();
        int chainIndex = 0;
        for (Class pluginClass : configuration.getChain()) {
            this.log.debug("Executing chained pluginClass {}", (Object)pluginClass);
            Object plugin = pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            MainGenerator.applyConfiguration(chainIndex++, plugin, configuration);
            if (plugin instanceof Parser) {
                Map<String, Object> parsed = ((Parser)plugin).withProjectClassLoader(configuration.getProjectClassLoader()).parse();
                model.putAll(parsed);
            }
            if (plugin instanceof Processor) {
                model = ((Processor)plugin).process(model);
            }
            if (plugin instanceof Generator) {
                templateOutputList.addAll(((Generator)plugin).generate(model));
            }
            if (plugin instanceof Formatter) {
                templateOutputList = ((Formatter)plugin).format(templateOutputList);
            }
            if (!(plugin instanceof TemplateWriter)) continue;
            ((TemplateWriter)plugin).write(templateOutputList);
        }
    }

    public static void applyConfiguration(int chainIndex, Object processor, Plugin plugin) throws JsonMappingException {
        Map<String, Object> options = plugin.getOptions();
        Object processorFullClassOptions = options.get(processor.getClass().getName());
        Object processorSimpleClassOptions = options.get(processor.getClass().getSimpleName());
        Object chainIndexOptions = options.get(String.valueOf(chainIndex));
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.addHandler((DeserializationProblemHandler)new CommaSeparatedCollectionDeserializationHandler());
        mapper.updateValue(processor, options);
        if (processorSimpleClassOptions != null) {
            mapper.updateValue(processor, processorSimpleClassOptions);
        }
        if (processorFullClassOptions != null) {
            mapper.updateValue(processor, processorFullClassOptions);
        }
        if (chainIndexOptions != null) {
            mapper.updateValue(processor, chainIndexOptions);
        }
        try {
            processor.getClass().getMethod("onPropertiesSet", new Class[0]).invoke(processor, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }
}

