/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk;

import io.zenwave360.sdk.doc.DocumentedOption;
import io.zenwave360.sdk.doc.DocumentedPlugin;
import io.zenwave360.sdk.utils.NamingUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class Plugin {
    @DocumentedOption(description="Spec file to parse", required=true)
    public String specFile;
    @DocumentedOption(description="Target folder for generated output", required=false)
    public String targetFolder;
    private List<Class> chain;
    private boolean forceOverwrite = false;
    private Map<String, Object> options = new HashMap<String, Object>();
    private ClassLoader projectClassLoader;

    public static Plugin of(String pluginConfigAsString) throws Exception {
        if (pluginConfigAsString != null) {
            if (pluginConfigAsString.contains(".")) {
                return (Plugin)Plugin.class.getClassLoader().loadClass(pluginConfigAsString).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            String simpleClassName = NamingUtils.asJavaTypeName(pluginConfigAsString);
            Set allConfigClasses = new Reflections("io.zenwave360.sdk.plugins", new Scanner[0]).getSubTypesOf(Plugin.class);
            Optional<Class> pluginClass = allConfigClasses.stream().filter(c -> Plugin.matchesClassName(c, pluginConfigAsString, simpleClassName)).findFirst();
            if (pluginClass.isPresent()) {
                return (Plugin)pluginClass.get().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        return new Plugin();
    }

    private static boolean matchesClassName(Class c, String pluginConfigAsString, String simpleClassName) {
        DocumentedPlugin documentedPlugin = c.getAnnotation(DocumentedPlugin.class);
        if (documentedPlugin != null && pluginConfigAsString.contentEquals(documentedPlugin.shortCode())) {
            return true;
        }
        return c.getSimpleName().matches(simpleClassName + "(Configuration){0,1}$");
    }

    public <T extends Plugin> T processOptions() {
        return (T)this;
    }

    public Plugin withSpecFile(String specFile) {
        this.specFile = specFile != null ? specFile.replaceAll("\\\\", "/") : specFile;
        this.options.put("specFile", this.specFile);
        return this;
    }

    public Plugin withTargetFolder(String targetFolder) {
        if (targetFolder != null) {
            this.targetFolder = targetFolder;
            this.options.put("targetFolder", targetFolder);
        }
        return this;
    }

    public Plugin withProjectClassLoader(ClassLoader projectClassLoader) {
        this.projectClassLoader = projectClassLoader;
        return this;
    }

    public Plugin withForceOverwrite(boolean forceOverwrite) {
        this.forceOverwrite = forceOverwrite;
        return this;
    }

    public Plugin withOption(String name, Object value) {
        String lastPath = name;
        Map nestedTempObject = this.options;
        String[] paths = name.split("\\.");
        for (int i = 0; i < paths.length; ++i) {
            lastPath = paths[i];
            if (!nestedTempObject.containsKey(lastPath)) {
                nestedTempObject.put((String)paths[i], new HashMap());
            }
            if (i >= paths.length - 1) continue;
            nestedTempObject = (Map)nestedTempObject.get(lastPath);
        }
        if (value instanceof String && ((String)((Object)value)).contains(",")) {
            value = Arrays.asList(((String)((Object)value)).split(","));
        }
        nestedTempObject.put((String)lastPath, (Object)value);
        try {
            if (FieldUtils.getField(this.getClass(), (String)name) != null) {
                FieldUtils.writeField((Object)this, (String)name, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public Plugin withOptions(Map<String, Object> options) {
        options.entrySet().forEach(o -> this.withOption((String)o.getKey(), o.getValue()));
        return this;
    }

    public Plugin withChain(Class ... processorClasses) {
        if (processorClasses != null) {
            this.chain = new ArrayList<Class>(List.of(processorClasses));
        }
        return this;
    }

    public Plugin removeFromChain(Class ... processorClasses) {
        Arrays.stream(processorClasses).forEach(processorClass -> this.chain.remove(processorClass));
        return this;
    }

    public Plugin replaceInChain(Class current, Class replacement) {
        this.chain.replaceAll(chainedProcessor -> chainedProcessor.equals(current) ? replacement : chainedProcessor);
        return this;
    }

    public Plugin addAfterInChain(Class pivot, Class newProcessor) {
        int index = this.chain.indexOf(pivot) + 1;
        if (index == -1) {
            this.chain.add(newProcessor);
        } else {
            this.chain.add(index, newProcessor);
        }
        return this;
    }

    public Plugin addBeforeInChain(Class pivot, Class newProcessor) {
        int index = this.chain.indexOf(pivot);
        if (index >= 0) {
            this.chain.add(index, newProcessor);
        } else {
            this.chain.add(newProcessor);
        }
        return this;
    }

    public boolean hasOption(String name) {
        return this.options.containsKey(name);
    }

    public boolean hasOption(String name, Object value) {
        if (name == null || this.options.get(name) == null || value == null) {
            return false;
        }
        return this.options.get(name).toString().equals(value.toString());
    }

    public String getSpecFile() {
        return this.specFile;
    }

    public void setSpecFile(String specFile) {
        this.specFile = specFile;
    }

    public List<Class> getChain() {
        return this.chain;
    }

    public void setChain(List<Class> chain) {
        this.chain = chain;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    public ClassLoader getProjectClassLoader() {
        return this.projectClassLoader;
    }
}

