/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.doc;

import io.zenwave360.sdk.doc.DocumentedPlugin;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

@SupportedAnnotationTypes(value={"io.zenwave360.sdk.doc.DocumentedPlugin"})
public final class PluginAnnotationProcessor
extends AbstractProcessor {
    private Elements elementUtils;

    @Override
    public void init(ProcessingEnvironment procEnv) {
        super.init(procEnv);
        this.elementUtils = procEnv.getElementUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> processableAnnotations, RoundEnvironment roundEnv) {
        try {
            Set<? extends Element> pluginElements = roundEnv.getElementsAnnotatedWith(DocumentedPlugin.class);
            for (Element element : pluginElements) {
                DocumentedPlugin documentedPluginAnnotation = element.getAnnotation(DocumentedPlugin.class);
                String docComment = this.elementUtils.getDocComment(element);
                if ("${javadoc}".contentEquals(documentedPluginAnnotation.description())) {
                    Object jcTree = MethodUtils.invokeMethod((Object)this.elementUtils, (String)"getTree", (Object[])new Object[]{element});
                    Object mods = FieldUtils.readField((Object)jcTree, (String)"mods", (boolean)true);
                    List annotations = (List)FieldUtils.readField((Object)mods, (String)"annotations", (boolean)true);
                    for (Object annotation : annotations) {
                        Object annotationType = FieldUtils.readField(annotation, (String)"annotationType", (boolean)true);
                        Object type = FieldUtils.readField((Object)annotationType, (String)"type", (boolean)true);
                        if (!DocumentedPlugin.class.getName().contentEquals(type.toString())) continue;
                        List args = (List)FieldUtils.readField(annotation, (String)"args", (boolean)true);
                        for (Object arg : args) {
                            Object lhs = FieldUtils.readField(arg, (String)"lhs", (boolean)true);
                            if (!"description".contentEquals(lhs.toString())) continue;
                            Object rhs = FieldUtils.readField(arg, (String)"rhs", (boolean)true);
                            FieldUtils.writeField((Object)rhs, (String)"value", (Object)docComment);
                        }
                    }
                }
                DocumentedPlugin annotation2 = element.getAnnotation(DocumentedPlugin.class);
                System.out.println("Annotation2 " + annotation2.description());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error processing DocumentedPlugin javadoc into annotation description", e);
        }
        return true;
    }

    private void updateAnnotationField(Annotation annotation, String field, String value) {
        Map memberValues;
        Field f;
        InvocationHandler handler = Proxy.getInvocationHandler(annotation);
        try {
            f = handler.getClass().getDeclaredField("memberValues");
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(e);
        }
        f.setAccessible(true);
        try {
            memberValues = (Map)f.get(handler);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        Object oldValue = memberValues.get(field);
        if (oldValue == null || oldValue.getClass() != value.getClass()) {
            throw new IllegalArgumentException();
        }
        memberValues.put(field, value);
    }
}

