/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.formatters;

import io.zenwave360.sdk.doc.DocumentedOption;
import io.zenwave360.sdk.formatters.Formatter;
import io.zenwave360.sdk.formatters.GoogleJavaFormatter;
import io.zenwave360.sdk.formatters.PalantirJavaFormatter;
import io.zenwave360.sdk.formatters.SpringJavaFormatter;
import io.zenwave360.sdk.templating.TemplateOutput;
import java.util.List;

public class JavaFormatter
implements Formatter {
    @DocumentedOption(description="Code formatter implementation")
    public Formatter.Formatters formatter = Formatter.Formatters.spring;
    @DocumentedOption(description="Skip java sources output formatting")
    public boolean skipFormatting = false;
    @DocumentedOption(description="Halt on formatting errors")
    public boolean haltOnFailFormatting = true;
    private Formatter delegate;

    public JavaFormatter() {
        this.onPropertiesSet();
    }

    public void onPropertiesSet() {
        switch (this.formatter) {
            case google: {
                this.delegate = new GoogleJavaFormatter(this.skipFormatting, this.haltOnFailFormatting);
                break;
            }
            case palantir: {
                this.delegate = new PalantirJavaFormatter(this.skipFormatting, this.haltOnFailFormatting);
                break;
            }
            case spring: {
                this.delegate = new SpringJavaFormatter(this.skipFormatting, this.haltOnFailFormatting);
                break;
            }
            default: {
                throw new RuntimeException("Unknown java formatter: " + this.formatter);
            }
        }
    }

    @Override
    public List<TemplateOutput> format(List<TemplateOutput> templateOutputList) {
        return this.delegate.format(templateOutputList);
    }
}

