/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.formatters;

import com.palantir.javaformat.java.FormatterDiagnostic;
import com.palantir.javaformat.java.FormatterException;
import com.palantir.javaformat.java.JavaFormatterOptions;
import io.zenwave360.sdk.doc.DocumentedOption;
import io.zenwave360.sdk.formatters.Formatter;
import io.zenwave360.sdk.templating.OutputFormatType;
import io.zenwave360.sdk.templating.TemplateOutput;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PalantirJavaFormatter
implements Formatter {
    private static Logger log = LoggerFactory.getLogger(PalantirJavaFormatter.class);
    @DocumentedOption(description="Skip java sources output formatting")
    public boolean skipFormatting = false;
    @DocumentedOption(description="Halt on formatting errors")
    public boolean haltOnFailFormatting = true;
    private final com.palantir.javaformat.java.Formatter formatter = com.palantir.javaformat.java.Formatter.createFormatter((JavaFormatterOptions)JavaFormatterOptions.builder().style(JavaFormatterOptions.Style.PALANTIR).build());

    public PalantirJavaFormatter(boolean skipFormatting, boolean haltOnFailFormatting) {
        this.skipFormatting = skipFormatting;
        this.haltOnFailFormatting = haltOnFailFormatting;
    }

    @Override
    public List<TemplateOutput> format(List<TemplateOutput> templateOutputList) {
        return templateOutputList.stream().map(t -> this.format((TemplateOutput)t)).collect(Collectors.toList());
    }

    public TemplateOutput format(TemplateOutput templateOutput) {
        block6: {
            if (this.skipFormatting) {
                log.debug("Skipping java formatting");
                return templateOutput;
            }
            if (templateOutput.getMimeType() != null && templateOutput.getMimeType().equals(OutputFormatType.JAVA.toString())) {
                if (templateOutput.getContent().startsWith("// formatter:off")) {
                    log.debug("Skipping java formatting for file {}", (Object)templateOutput.getTargetFile());
                    return templateOutput;
                }
                try {
                    String formattedSource = this.formatter.formatSourceAndFixImports(templateOutput.getContent());
                    return new TemplateOutput(templateOutput.getTargetFile(), formattedSource, templateOutput.getMimeType(), templateOutput.isSkipOverwrite());
                }
                catch (FormatterException e) {
                    if (e.diagnostics() != null && e.diagnostics().size() > 0) {
                        int line = ((FormatterDiagnostic)e.diagnostics().get(0)).line();
                        String lineText = this.getLine(templateOutput.getContent(), line + 1);
                        log.error("Formatting error at {}:{} -> \"{}\"", new Object[]{templateOutput.getTargetFile(), line, lineText, e});
                    }
                    if (!this.haltOnFailFormatting) break block6;
                    throw new RuntimeException(e);
                }
            }
        }
        return templateOutput;
    }

    public String getLine(String content, int line) {
        try {
            return content.split("\\r?\\n")[line];
        }
        catch (Exception e) {
            return "";
        }
    }
}

