/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.formatters;

import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.java.CustomFormatter;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.ImportOrderer;
import com.google.googlejavaformat.java.RemoveUnusedImports;
import io.spring.javaformat.config.JavaFormatConfig;
import io.zenwave360.sdk.doc.DocumentedOption;
import io.zenwave360.sdk.formatters.Formatter;
import io.zenwave360.sdk.templating.OutputFormatType;
import io.zenwave360.sdk.templating.TemplateOutput;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringJavaFormatter
implements Formatter {
    private static Logger log = LoggerFactory.getLogger(SpringJavaFormatter.class);
    @DocumentedOption(description="Skip java sources output formatting")
    public boolean skipFormatting = false;
    @DocumentedOption(description="Halt on formatting errors")
    public boolean haltOnFailFormatting = true;
    private final io.spring.javaformat.formatter.Formatter formatter = new io.spring.javaformat.formatter.Formatter(JavaFormatConfig.findFrom((File)new File(".")));
    private final CustomFormatter googleCustomFormatter = new CustomFormatter();

    public SpringJavaFormatter(boolean skipFormatting, boolean haltOnFailFormatting) {
        this.skipFormatting = skipFormatting;
        this.haltOnFailFormatting = haltOnFailFormatting;
    }

    @Override
    public List<TemplateOutput> format(List<TemplateOutput> templateOutputList) {
        return templateOutputList.stream().map(t -> this.format((TemplateOutput)t)).collect(Collectors.toList());
    }

    public TemplateOutput format(TemplateOutput templateOutput) {
        block8: {
            if (this.skipFormatting) {
                log.debug("Skipping java formatting");
                return templateOutput;
            }
            if (templateOutput.getMimeType() != null && templateOutput.getMimeType().equals(OutputFormatType.JAVA.toString())) {
                if (templateOutput.getContent().startsWith("// formatter:off")) {
                    log.debug("Skipping java formatting for file {}", (Object)templateOutput.getTargetFile());
                    return templateOutput;
                }
                try {
                    String formattedSource = this.googleCustomFormatter.formatSourceAndFixImports(templateOutput.getContent());
                    formattedSource = this.formatSourceWithSpringJavaFormat(formattedSource);
                    return new TemplateOutput(templateOutput.getTargetFile(), formattedSource, templateOutput.getMimeType(), templateOutput.isSkipOverwrite());
                }
                catch (FormatterException e) {
                    if (e.diagnostics() != null && e.diagnostics().size() > 0) {
                        int line = ((FormatterDiagnostic)e.diagnostics().get(0)).line();
                        String lineText = this.getLine(templateOutput.getContent(), line + 1);
                        log.error("Formatting error at {}:{} -> \"{}\"", new Object[]{templateOutput.getTargetFile(), line, lineText, e});
                    }
                    if (this.haltOnFailFormatting) {
                        throw new RuntimeException(e);
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    if (!this.haltOnFailFormatting) break block8;
                    throw new RuntimeException(e);
                }
            }
        }
        return templateOutput;
    }

    public String getLine(String content, int line) {
        try {
            return content.split("\\r?\\n")[line];
        }
        catch (Exception e) {
            return "";
        }
    }

    protected String formatSourceWithSpringJavaFormat(String source) throws BadLocationException {
        TextEdit edit = this.formatter.format(source);
        Document document = new Document(source);
        edit.apply((IDocument)document);
        return document.get();
    }

    public String fixImports(String input) throws FormatterException {
        input = ImportOrderer.reorderImports((String)input);
        input = RemoveUnusedImports.removeUnusedImports((String)input);
        return input;
    }
}

