/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.generators;

import io.zenwave360.sdk.doc.DocumentedOption;
import io.zenwave360.sdk.generators.Generator;
import io.zenwave360.sdk.options.asyncapi.AsyncapiOperationType;
import io.zenwave360.sdk.options.asyncapi.AsyncapiRoleType;
import io.zenwave360.sdk.options.asyncapi.AsyncapiVersionType;
import io.zenwave360.sdk.parsers.Model;
import io.zenwave360.sdk.templating.HandlebarsEngine;
import io.zenwave360.sdk.templating.OutputFormatType;
import io.zenwave360.sdk.templating.TemplateInput;
import io.zenwave360.sdk.templating.TemplateOutput;
import io.zenwave360.sdk.utils.JSONPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractAsyncapiGenerator
implements Generator {
    public String sourceProperty = "api";
    @DocumentedOption(description="Java API package name for producerApiPackage and consumerApiPackage if not specified.")
    public String apiPackage;
    @DocumentedOption(description="Java API package name for outbound (producer) services. It can override apiPackage for producers.")
    public String producerApiPackage = "{{apiPackage}}";
    @DocumentedOption(description="Java API package name for inbound (consumer) services. It can override apiPackage for consumer.")
    public String consumerApiPackage = "{{apiPackage}}";
    @DocumentedOption(description="Java Models package name")
    public String modelPackage;
    @DocumentedOption(description="Binding names to include in code generation. Generates code for ALL bindings if left empty")
    public List<String> bindingTypes;
    @DocumentedOption(description="Project role: provider/client")
    public AsyncapiRoleType role = AsyncapiRoleType.provider;
    @DocumentedOption(description="Operation ids to include in code generation. Generates code for ALL if left empty")
    public List<String> operationIds = new ArrayList<String>();
    @DocumentedOption(description="Operation ids to exclude in code generation. Skips code generation if is not included or is excluded.")
    public List<String> excludeOperationIds = new ArrayList<String>();
    private final HandlebarsEngine handlebarsEngine = new HandlebarsEngine();

    protected Model getApiModel(Map<String, Object> contextModel) {
        return (Model)contextModel.get(this.sourceProperty);
    }

    protected HandlebarsEngine getTemplateEngine() {
        return this.handlebarsEngine;
    }

    protected abstract Templates configureTemplates();

    @Override
    public List<TemplateOutput> generate(Map<String, Object> contextModel) {
        OperationRoleType operationRoleType;
        Templates templates = this.configureTemplates();
        Model apiModel = this.getApiModel(contextModel);
        Map<String, List<Map<String, Object>>> subscribeOperations = this.getSubscribeOperationsGroupedByTag(apiModel);
        Map<String, List<Map<String, Object>>> publishOperations = this.getPublishOperationsGroupedByTag(apiModel);
        HashMap<String, Map<String, Object>> producerServicesMap = new HashMap<String, Map<String, Object>>();
        HashMap consumerServicesMap = new HashMap();
        ArrayList<TemplateOutput> templateOutputList = new ArrayList<TemplateOutput>();
        templateOutputList.addAll(this.generateTemplateOutput(contextModel, templates.commonTemplates, Map.of()));
        for (Map.Entry<String, List<Map<String, Object>>> operationsByTag : subscribeOperations.entrySet()) {
            operationRoleType = OperationRoleType.valueOf(this.role, AsyncapiOperationType.subscribe);
            templateOutputList.addAll(this.processServiceOperations(contextModel, operationsByTag, operationRoleType, templates));
            this.addToServicesMap(operationRoleType.isProducer() ? producerServicesMap : consumerServicesMap, operationsByTag, operationRoleType);
        }
        for (Map.Entry<String, List<Map<String, Object>>> operationsByTag : publishOperations.entrySet()) {
            operationRoleType = OperationRoleType.valueOf(this.role, AsyncapiOperationType.publish);
            templateOutputList.addAll(this.processServiceOperations(contextModel, operationsByTag, operationRoleType, templates));
            this.addToServicesMap(operationRoleType.isProducer() ? producerServicesMap : consumerServicesMap, operationsByTag, operationRoleType);
        }
        if (!producerServicesMap.isEmpty()) {
            templateOutputList.addAll(this.generateTemplateOutput(contextModel, templates.producerTemplates, Map.of("services", producerServicesMap)));
        }
        if (!consumerServicesMap.isEmpty()) {
            templateOutputList.addAll(this.generateTemplateOutput(contextModel, templates.consumerTemplates, Map.of("services", consumerServicesMap)));
        }
        return templateOutputList;
    }

    public List<TemplateOutput> processServiceOperations(Map<String, Object> contextModel, Map.Entry<String, List<Map<String, Object>>> operationsByTag, OperationRoleType operationRoleType, Templates templates) {
        boolean isProducer = operationRoleType.isProducer();
        String serviceName = operationsByTag.getKey();
        List<Map<String, Object>> operations = operationsByTag.getValue();
        HashSet messages = new HashSet((Collection)JSONPath.get(operations, "$[*].x--messages[*]"));
        ArrayList<TemplateOutput> templateOutputList = new ArrayList<TemplateOutput>();
        templateOutputList.addAll(this.generateTemplateOutput(contextModel, isProducer ? templates.producerByServiceTemplates : templates.consumerByServiceTemplates, Map.of("serviceName", serviceName, "operations", operations, "messages", messages, "operationRoleType", operationRoleType)));
        for (Map<String, Object> operation : operations) {
            messages = new HashSet((Collection)JSONPath.get(operation, "$.x--messages[*]"));
            templateOutputList.addAll(this.generateTemplateOutput(contextModel, isProducer ? templates.producerByOperationTemplates : templates.consumerByOperationTemplates, Map.of("serviceName", serviceName, "operation", operation, "messages", messages, "operationRoleType", operationRoleType)));
        }
        return templateOutputList;
    }

    public void addToServicesMap(Map<String, Map<String, Object>> servicesMap, Map.Entry<String, List<Map<String, Object>>> operationsByTag, OperationRoleType operationRoleType) {
        String serviceName = operationsByTag.getKey();
        List<Map<String, Object>> operations = operationsByTag.getValue();
        servicesMap.put(serviceName, Map.of("operations", operations, "operationRoleType", operationRoleType));
    }

    public Map<String, List<Map<String, Object>>> getPublishOperationsGroupedByTag(Model apiModel) {
        return this.getOperationsGroupedByTag(apiModel, AsyncapiOperationType.publish);
    }

    public Map<String, List<Map<String, Object>>> getSubscribeOperationsGroupedByTag(Model model) {
        return this.getOperationsGroupedByTag(model, AsyncapiOperationType.subscribe);
    }

    public Map<String, List<Map<String, Object>>> getOperationsGroupedByTag(Model apiModel, AsyncapiOperationType operationType) {
        boolean isV2 = AsyncapiVersionType.isV2(apiModel);
        boolean isV3 = AsyncapiVersionType.isV3(apiModel);
        if (isV2) {
            return this.getOperationsGroupedByTagV2(apiModel, operationType);
        }
        if (isV3) {
            return this.getOperationsGroupedByTagV3(apiModel, operationType);
        }
        return null;
    }

    public Map<String, List<Map<String, Object>>> getOperationsGroupedByTagV2(Model apiModel, AsyncapiOperationType operationType) {
        HashMap<String, List<Map<String, Object>>> operationsByTag = new HashMap<String, List<Map<String, Object>>>();
        List operations = (List)JSONPath.get(apiModel, "$.channels[*].*");
        for (Object operationObject : operations) {
            Map operation;
            if (operationObject != null && JSONPath.get(operationObject, "$.operationId") == null || !this.matchesFilters(operation = (Map)operationObject, operationType)) continue;
            String tag = (String)ObjectUtils.firstNonNull((Object[])new Object[]{operation.get("x--normalizedTagName"), "DefaultService"});
            if (!operationsByTag.containsKey(tag)) {
                operationsByTag.put(tag, new ArrayList());
            }
            ((List)operationsByTag.get(tag)).add(operation);
        }
        return operationsByTag;
    }

    public Map<String, List<Map<String, Object>>> getOperationsGroupedByTagV3(Model apiModel, AsyncapiOperationType operationType) {
        HashMap<String, List<Map<String, Object>>> operationsByTag = new HashMap<String, List<Map<String, Object>>>();
        List operations = (List)JSONPath.get(apiModel, "$.operations[*]");
        for (Map operation : operations) {
            if (!this.matchesFilters(operation, operationType)) continue;
            String tag = (String)ObjectUtils.firstNonNull((Object[])new Object[]{operation.get("x--normalizedTagName"), "DefaultService"});
            if (!operationsByTag.containsKey(tag)) {
                operationsByTag.put(tag, new ArrayList());
            }
            ((List)operationsByTag.get(tag)).add(operation);
        }
        return operationsByTag;
    }

    public boolean matchesFilters(Map<String, Object> operation, AsyncapiOperationType operationType) {
        AsyncapiOperationType operationOperationType = this.getOperationType(operation);
        return operationType.isEquivalent(operationOperationType) && this.matchesBindingTypes(operation, this.bindingTypes) && !this.isSkipOperation(operation);
    }

    private AsyncapiOperationType getOperationType(Map<String, Object> operation) {
        Object v2OperationType = operation.get("x--operationType");
        Object v3Action = operation.get("action");
        Object operationType = ObjectUtils.firstNonNull((Object[])new Object[]{v2OperationType, v3Action});
        return operationType != null ? AsyncapiOperationType.valueOf(operationType.toString()) : null;
    }

    public boolean matchesBindingTypes(Map<String, Object> operation, List<String> bindingTypes) {
        if (bindingTypes == null || bindingTypes.isEmpty()) {
            return true;
        }
        Map bindings = (Map)ObjectUtils.defaultIfNull((Object)((Map)operation.get("bindings")), Collections.emptyMap());
        Set bindingNames = bindings.keySet();
        for (String bindingName : bindingNames) {
            if (!bindingTypes.contains(bindingName)) continue;
            return true;
        }
        return false;
    }

    public boolean isSkipOperation(Map<String, Object> operation) {
        boolean isIncluded = true;
        if (this.operationIds != null && !this.operationIds.isEmpty()) {
            isIncluded = this.operationIds.contains((String)operation.get("operationId"));
        }
        boolean isExcluded = false;
        if (this.excludeOperationIds != null && !this.excludeOperationIds.isEmpty()) {
            isExcluded = this.excludeOperationIds.contains((String)operation.get("operationId"));
        }
        return !isIncluded || isExcluded;
    }

    public boolean isProducer(AsyncapiRoleType roleType, AsyncapiOperationType operationType) {
        return AsyncapiRoleType.provider == roleType && AsyncapiOperationType.publish.isEquivalent(operationType) || AsyncapiRoleType.client == roleType && AsyncapiOperationType.subscribe.isEquivalent(operationType);
    }

    protected List<TemplateOutput> generateTemplateOutput(Map<String, Object> contextModel, List<TemplateInput> templates, Map<String, Object> extModel) {
        HashMap<String, Object> baseModel = new HashMap<String, Object>();
        baseModel.putAll(this.asConfigurationMap());
        baseModel.put("context", contextModel);
        baseModel.put("asyncapi", this.getApiModel(contextModel));
        ArrayList<TemplateOutput> templateOutputList = new ArrayList<TemplateOutput>();
        for (TemplateInput template : templates) {
            HashMap<String, Object> model = new HashMap<String, Object>(baseModel);
            model.putAll(extModel);
            templateOutputList.addAll(this.getTemplateEngine().processTemplates(model, List.of(template)));
        }
        return templateOutputList;
    }

    public static class Templates {
        public final String templatesFolder;
        public List<TemplateInput> commonTemplates = new ArrayList<TemplateInput>();
        public List<TemplateInput> producerTemplates = new ArrayList<TemplateInput>();
        public List<TemplateInput> producerByServiceTemplates = new ArrayList<TemplateInput>();
        public List<TemplateInput> producerByOperationTemplates = new ArrayList<TemplateInput>();
        public List<TemplateInput> consumerTemplates = new ArrayList<TemplateInput>();
        public List<TemplateInput> consumerByServiceTemplates = new ArrayList<TemplateInput>();
        public List<TemplateInput> consumerByOperationTemplates = new ArrayList<TemplateInput>();

        public Templates(String templatesFolder) {
            this.templatesFolder = templatesFolder;
        }

        public void addTemplate(List<TemplateInput> templates, String templateLocation, String targetFile) {
            this.addTemplate(templates, templateLocation, targetFile, OutputFormatType.JAVA, null, false);
        }

        public void addTemplate(List<TemplateInput> templates, String templateLocation, String targetFile, OutputFormatType mimeType, Function<Map<String, Object>, Boolean> skip, boolean skipOverwrite) {
            TemplateInput template = new TemplateInput().withTemplateLocation(this.templatesFolder + "/" + templateLocation).withTargetFile(targetFile).withMimeType(mimeType).withSkipOverwrite(skipOverwrite).withSkip(skip);
            templates.add(template);
        }
    }

    public static enum OperationRoleType {
        EVENT_PRODUCER("EventsProducer"),
        EVENT_CONSUMER("EventsConsumer"),
        COMMAND_PRODUCER("CommandsProducer"),
        COMMAND_CONSUMER("CommandsConsumer");

        private String serviceSuffix;

        private OperationRoleType(String serviceSuffix) {
            this.serviceSuffix = serviceSuffix;
        }

        public String getServiceSuffix() {
            return this.serviceSuffix;
        }

        public static OperationRoleType valueOf(AsyncapiRoleType roleType, AsyncapiOperationType operationType) {
            if (operationType == AsyncapiOperationType.publish) {
                return roleType == AsyncapiRoleType.provider ? EVENT_PRODUCER : EVENT_CONSUMER;
            }
            if (operationType == AsyncapiOperationType.subscribe) {
                return roleType == AsyncapiRoleType.provider ? COMMAND_CONSUMER : COMMAND_PRODUCER;
            }
            return null;
        }

        public boolean isProducer() {
            return this == EVENT_PRODUCER || this == COMMAND_PRODUCER;
        }
    }
}

