/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.generators;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.zenwave360.sdk.doc.DocumentedOption;
import io.zenwave360.sdk.generators.Generator;
import io.zenwave360.sdk.parsers.Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractOpenAPIGenerator
implements Generator {
    @DocumentedOption(description="Applications base package")
    public String basePackage;
    @DocumentedOption(description="The package to used by OpenAPI-Generator for generated api objects/classes")
    public String openApiApiPackage;
    @DocumentedOption(description="The package to used by OpenAPI-Generator for generated model objects/classes")
    public String openApiModelPackage = "{{openApiApiPackage}}";
    @DocumentedOption(description="Sets the prefix for model enums and classes used by OpenAPI-Generator")
    public String openApiModelNamePrefix = "";
    @DocumentedOption(description="Sets the suffix for model enums and classes used by OpenAPI-Generator")
    public String openApiModelNameSuffix = "";
    @DocumentedOption(description="OpenAPI operationIds to generate code for")
    public List<String> operationIds = new ArrayList<String>();
    @DocumentedOption(description="Status codes to generate code for")
    public List<String> statusCodes = List.of("200", "201", "202", "400");

    public String getApiPackageFolder() {
        return this.openApiApiPackage.replaceAll("\\.", "/");
    }

    public String getModelPackageFolder() {
        return this.openApiModelPackage.replaceAll("\\.", "/");
    }

    public Map<String, List<Map<String, Object>>> getOperationsGroupedByTag(Model apiModel, OperationType ... operationTypes) {
        HashMap<String, List<Map<String, Object>>> operationsByTag = new HashMap<String, List<Map<String, Object>>>();
        List operations = (List)JsonPath.read((Object)apiModel, (String)"$.paths[*].*", (Predicate[])new Predicate[0]);
        for (Map operation : operations) {
            if (!this.matchesFilters(operation, operationTypes)) continue;
            String tag = (String)ObjectUtils.firstNonNull((Object[])new Object[]{operation.get("x--normalizedTagName"), "Default"});
            if (!operationsByTag.containsKey(tag)) {
                operationsByTag.put(tag, new ArrayList());
            }
            ((List)operationsByTag.get(tag)).add(operation);
        }
        return operationsByTag;
    }

    public boolean matchesFilters(Map<String, Object> operation, OperationType ... operationTypes) {
        OperationType operationOperationType = OperationType.valueOf(operation.get("x--httpVerb").toString().toUpperCase());
        return this.matchedOperationTypes(operation, operationOperationType, operationTypes) && this.matchesOperationIds(operation, this.operationIds);
    }

    protected boolean matchedOperationTypes(Map<String, Object> operation, OperationType operationOperationType, OperationType ... operationTypes) {
        return operationTypes == null || operationTypes.length == 0 || Arrays.stream(operationTypes).anyMatch(operationType -> operationOperationType == operationType);
    }

    protected boolean matchesOperationIds(Map<String, Object> operation, List<String> operationIds) {
        if (operationIds == null || operationIds.isEmpty()) {
            return true;
        }
        String operationId = (String)operation.get("operationId");
        return operationIds.contains(operationId);
    }

    public static enum OperationType {
        GET,
        PUT,
        POST,
        DELETE,
        PATCH,
        HEAD,
        PARAMETERS;

    }
}

