/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.generators;

import io.zenwave360.sdk.generators.AbstractZDLGenerator;
import io.zenwave360.sdk.generators.ZDLProjectTemplates;
import io.zenwave360.sdk.templating.HandlebarsEngine;
import io.zenwave360.sdk.templating.TemplateInput;
import io.zenwave360.sdk.templating.TemplateOutput;
import io.zenwave360.sdk.utils.JSONPath;
import io.zenwave360.sdk.zdl.ZDLFindUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractZDLProjectGenerator
extends AbstractZDLGenerator {
    public String sourceProperty = "zdl";
    private final HandlebarsEngine handlebarsEngine = new HandlebarsEngine();

    protected HandlebarsEngine getTemplateEngine() {
        return this.handlebarsEngine;
    }

    protected abstract ZDLProjectTemplates configureProjectTemplates();

    protected abstract boolean isGenerateEntity(Map<String, Object> var1);

    protected Map<String, Object> getZDLModel(Map<String, Object> contextModel) {
        return (Map)contextModel.get(this.sourceProperty);
    }

    @Override
    public List<TemplateOutput> generate(Map<String, Object> contextModel) {
        ZDLProjectTemplates templates = this.configureProjectTemplates();
        ArrayList<TemplateOutput> templateOutputList = new ArrayList<TemplateOutput>();
        Map<String, Object> apiModel = this.getZDLModel(contextModel);
        Map aggregates = (Map)apiModel.get("aggregates");
        HashSet domainEvents = new HashSet();
        for (Map map : aggregates.values()) {
            for (TemplateInput templateInput : templates.aggregateTemplates) {
                templateOutputList.addAll(this.generateTemplateOutput(contextModel, templateInput, Map.of("aggregate", map)));
            }
            Set<String> events = ZDLFindUtils.aggregateEvents(map);
            Iterator<String> iterator = events.iterator();
            while (iterator.hasNext()) {
                String eventName = iterator.next();
                Object event = JSONPath.get(apiModel, "$.events." + eventName);
                if (event == null) continue;
                domainEvents.add((Map)event);
            }
        }
        domainEvents.addAll(JSONPath.get(apiModel, "$.events[*][?(!@.options.asyncapi && !@.options.embedded)]", List.of()));
        JSONPath.get(new ArrayList(domainEvents), "$..fields[*].type", List.of()).stream().map(type -> (Map)JSONPath.get(apiModel, "$.events." + type)).filter(Objects::nonNull).forEach(domainEvents::add);
        for (Map map : domainEvents) {
            for (TemplateInput templateInput : templates.domainEventsTemplates) {
                templateOutputList.addAll(this.generateTemplateOutput(contextModel, templateInput, Map.of("event", map)));
            }
        }
        Map entities = (Map)apiModel.get("entities");
        for (Object entity2 : entities.values()) {
            if (!this.isGenerateEntity((Map<String, Object>)entity2)) continue;
            for (TemplateInput template : templates.entityTemplates) {
                templateOutputList.addAll(this.generateTemplateOutput(contextModel, template, Map.of("entity", entity2)));
            }
        }
        Map map = (Map)JSONPath.get(apiModel, "$.enums");
        for (Map map2 : map.values()) {
            if (!this.isGenerateEntity(map2)) continue;
            Object comment = map2.get("comment");
            Boolean isInputEnum = JSONPath.get(map2, "$.options.input", false);
            Boolean isEventEnum = JSONPath.get(map2, "$.options.event", false);
            if (isInputEnum.booleanValue()) {
                for (TemplateInput template : templates.inputEnumTemplates) {
                    templateOutputList.addAll(this.generateTemplateOutput(contextModel, template, Map.of("enum", map2)));
                }
                continue;
            }
            if (isEventEnum.booleanValue()) {
                for (TemplateInput template : templates.eventEnumTemplates) {
                    templateOutputList.addAll(this.generateTemplateOutput(contextModel, template, Map.of("enum", map2)));
                }
                continue;
            }
            for (TemplateInput template : templates.enumTemplates) {
                templateOutputList.addAll(this.generateTemplateOutput(contextModel, template, Map.of("enum", map2)));
            }
        }
        List<Object> inputs = JSONPath.get(apiModel, "$.inputs[*]", Collections.emptyList());
        for (Object input : inputs) {
            for (TemplateInput template : templates.inputTemplates) {
                templateOutputList.addAll(this.generateTemplateOutput(contextModel, template, Map.of("entity", input)));
            }
        }
        List<Map> list = JSONPath.get(apiModel, "$.outputs[*]", Collections.emptyList());
        for (Map output : list) {
            for (TemplateInput template : templates.outputTemplates) {
                templateOutputList.addAll(this.generateTemplateOutput(contextModel, template, Map.of("entity", output)));
            }
        }
        Map services = JSONPath.get(apiModel, "$.options.options.service", Collections.emptyMap());
        ArrayList<Map> servicesList = new ArrayList<Map>();
        for (Map service : services.values()) {
            String serviceName = (String)service.get("value");
            service.put("name", serviceName);
            List<Map<String, Object>> entitiesByService = this.getEntitiesByService(service, apiModel);
            service.put("entities", entitiesByService);
            boolean isGenerateService = entitiesByService.stream().anyMatch(entity -> this.isGenerateEntity((Map<String, Object>)entity));
            if (!isGenerateService) continue;
            servicesList.add(service);
            for (TemplateInput template : templates.serviceTemplates) {
                templateOutputList.addAll(this.generateTemplateOutput(contextModel, template, Map.of("service", service, "entities", entitiesByService)));
            }
        }
        for (TemplateInput template : templates.allServicesTemplates) {
            templateOutputList.addAll(this.generateTemplateOutput(contextModel, template, Map.of("services", servicesList, "entities", new ArrayList(entities.values()))));
        }
        for (TemplateInput template : templates.singleTemplates) {
            templateOutputList.addAll(this.generateTemplateOutput(contextModel, template, Collections.emptyMap()));
        }
        return templateOutputList;
    }

    protected List<Map<String, Object>> getEntitiesByService(Map<String, Object> service, Map<String, Object> apiModel) {
        List entityNames = (List)service.get("entityNames");
        if (entityNames.size() == 1 && "*".equals(entityNames.get(0))) {
            entityNames = (List)JSONPath.get(apiModel, "$.entities[*].name");
        }
        entityNames = entityNames.stream().map(entity -> JSONPath.get(apiModel, "$.aggregates." + entity + ".aggregateRoot", entity)).toList();
        List<Object> entitiesByService = entityNames.stream().map(e -> JSONPath.get(apiModel, "$.entities." + e)).toList();
        List excludedNames = (List)service.get("excludedNames");
        if (excludedNames != null && excludedNames.size() > 0) {
            entitiesByService = entitiesByService.stream().filter(e -> !excludedNames.contains(e.get("name"))).collect(Collectors.toList());
        }
        service.put("entityNames", entityNames);
        return entitiesByService;
    }

    protected List<TemplateOutput> generateTemplateOutput(Map<String, Object> contextModel, TemplateInput template, Map<String, Object> extModel) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.putAll(this.asConfigurationMap());
        model.put("context", contextModel);
        model.put(this.sourceProperty, this.getZDLModel(contextModel));
        model.putAll(extModel);
        return this.getTemplateEngine().processTemplates(model, List.of(template));
    }
}

