/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.generators;

import io.zenwave360.sdk.parsers.ZDLParser;
import io.zenwave360.sdk.utils.JSONPath;
import io.zenwave360.sdk.utils.Lists;
import io.zenwave360.sdk.utils.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EntitiesToAvroConverter {
    public String idType = "string";
    public String namespace = "com.example.please.update";

    public EntitiesToAvroConverter withIdType(String idType) {
        this.idType = idType;
        return this;
    }

    public EntitiesToAvroConverter withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public Map<String, Object> convertToAvro(Map<String, Object> entityOrEnum, Map<String, Object> zdlModel) {
        boolean isEnum = entityOrEnum.get("values") != null;
        return isEnum ? this.convertEnumToAvro(entityOrEnum) : this.convertEntityToAvro(entityOrEnum, zdlModel);
    }

    public Map<String, Object> convertEnumToAvro(Map<String, Object> enumValue) {
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        schema.put("type", "enum");
        schema.put("name", enumValue.get("name"));
        schema.put("namespace", this.namespace);
        if (enumValue.get("comment") != null) {
            schema.put("doc", enumValue.get("comment"));
        }
        List values = (List)JSONPath.get(enumValue, "$.values..name");
        schema.put("symbols", values);
        return schema;
    }

    public Map<String, Object> convertEntityToAvro(Map<String, Object> entity, Map<String, Object> zdlModel) {
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        schema.put("type", "record");
        schema.put("name", entity.get("name"));
        schema.put("namespace", this.namespace);
        if (entity.get("comment") != null) {
            schema.put("doc", entity.get("comment"));
        }
        List fields = new ArrayList<Map<String, String>>();
        schema.put("fields", fields);
        if (EntitiesToAvroConverter.includeIdAndVersion(entity)) {
            fields.add(Maps.of("name", "id", "type", this.idType));
        }
        List entityFields = (List)JSONPath.get(entity, "$.fields[*]");
        String superClassName = (String)JSONPath.get(entity, "$.options.extends");
        if (superClassName != null) {
            List superClassFields = (List)JSONPath.get(zdlModel, "$.entities['" + superClassName + "'].fields[*]");
            fields = Lists.concat(superClassFields, fields);
        }
        for (Map entityField : entityFields) {
            boolean isRequired = JSONPath.get(entityField, "$.validations.required.value") != null;
            Map<Object, Object> field = new LinkedHashMap<String, Object>();
            field.put("name", entityField.get("name"));
            if ("String".equals(entityField.get("type")) || "TextBlob".equals(entityField.get("type"))) {
                field.put("type", this.typeList("string", isRequired));
            } else if ("Enum".equals(entityField.get("type"))) {
                field.put("type", this.typeList("string", isRequired));
            } else if ("LocalDate".equals(entityField.get("type"))) {
                field.put("type", this.typeList("string", isRequired));
            } else if ("ZonedDateTime".equals(entityField.get("type"))) {
                field.put("type", this.typeList("string", isRequired));
            } else if ("Instant".equals(entityField.get("type"))) {
                field.put("type", this.typeList("string", isRequired));
            } else if ("Duration".equals(entityField.get("type"))) {
                field.put("type", this.typeList("string", isRequired));
            } else if ("Integer".equals(entityField.get("type")) || "int".equals(entityField.get("type"))) {
                field.put("type", this.typeList("int", isRequired));
            } else if ("Long".equals(entityField.get("type")) || "long".equals(entityField.get("type"))) {
                field.put("type", this.typeList("long", isRequired));
            } else if ("Float".equals(entityField.get("type")) || "float".equals(entityField.get("type"))) {
                field.put("type", this.typeList("float", isRequired));
            } else if ("Double".equals(entityField.get("type")) || "double".equals(entityField.get("type")) || "BigDecimal".equals(entityField.get("type"))) {
                field.put("type", this.typeList("double", isRequired));
            } else if ("Boolean".equals(entityField.get("type")) || "boolean".equals(entityField.get("type"))) {
                field.put("type", this.typeList("boolean", isRequired));
            } else if ("UUID".equals(entityField.get("type"))) {
                field.put("type", this.typeList("string", isRequired));
            } else if (ZDLParser.blobTypes.contains(entityField.get("type"))) {
                field.put("type", this.typeList("bytes", isRequired));
            } else if ("Map".equals(entityField.get("type"))) {
                field.put("type", Map.of("type", "map", "values", "string"));
            } else {
                field.put("type", entityField.get("type"));
            }
            if (entityField.get("comment") != null) {
                field.put("doc", entityField.get("comment"));
            }
            if (entityField.get("isArray") == Boolean.TRUE) {
                field = Maps.of("name", field.get("name"), "type", Maps.of("type", "array", "items", field.get("type"), "java-class", "java.util.List"));
            }
            fields.add(field);
        }
        List<Map> relationships = JSONPath.get(entity, "$.relationships[*]", Collections.emptyList());
        if (superClassName != null) {
            List superClassRelationships = (List)JSONPath.get(zdlModel, "$.entities['" + superClassName + "'].relationships[*]");
            relationships = Lists.concat(superClassRelationships, relationships);
        }
        for (Map relationship : relationships) {
            if (relationship.get("fieldName") == null || !relationship.getOrDefault("ownerSide", false).booleanValue()) continue;
            boolean isCollection = relationship.get("isCollection") == Boolean.TRUE;
            Map<String, Object> field = new LinkedHashMap();
            field.put("name", relationship.get("name"));
            if (relationship.get("comment") != null) {
                field.put("doc", relationship.get("comment"));
            }
            field.put("type", relationship.get("otherEntityName"));
            if (isCollection) {
                field = Maps.of("type", "array", "items", field);
            }
            fields.add(field);
        }
        return schema;
    }

    private Object typeList(String type, boolean isRequired) {
        return isRequired ? type : Arrays.asList("null", type);
    }

    private static boolean includeIdAndVersion(Map<String, Object> entity) {
        return "entities".equals(entity.get("type")) && JSONPath.get(entity, "options.embedded", false) == false;
    }

    private static Object asNumber(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return number;
        }
    }
}

