/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.generators;

import io.zenwave360.sdk.parsers.ZDLParser;
import io.zenwave360.sdk.utils.JSONPath;
import io.zenwave360.sdk.utils.Lists;
import io.zenwave360.sdk.utils.Maps;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EntitiesToSchemasConverter {
    public String zdlBusinessEntityProperty = "x-business-entity";
    public String idType = "string";
    public String idTypeFormat = null;
    public boolean includeVersion = true;

    public EntitiesToSchemasConverter withIdType(String idType) {
        this.idType = idType;
        return this;
    }

    public EntitiesToSchemasConverter withIdType(String idType, String idTypeFormat) {
        this.idType = idType;
        this.idTypeFormat = idTypeFormat;
        return this;
    }

    protected Map idTypeMap() {
        LinkedHashMap<String, String> idType = new LinkedHashMap<String, String>();
        idType.put("type", this.idType);
        if (this.idTypeFormat != null) {
            idType.put("format", this.idTypeFormat);
        }
        return idType;
    }

    public EntitiesToSchemasConverter withZdlBusinessEntityProperty(String zdlBusinessEntityProperty) {
        this.zdlBusinessEntityProperty = zdlBusinessEntityProperty;
        return this;
    }

    public Map<String, Object> convertToSchema(Map<String, Object> entityOrEnum, Map<String, Object> zdlModel) {
        boolean isEnum = entityOrEnum.get("values") != null;
        return isEnum ? this.convertEnumToSchema(entityOrEnum, zdlModel) : this.convertEntityToSchema(entityOrEnum, zdlModel);
    }

    public Map<String, Object> convertEnumToSchema(Map<String, Object> enumValue, Map<String, Object> zdlModelv) {
        LinkedHashMap<String, Object> enumSchema = new LinkedHashMap<String, Object>();
        enumSchema.put("type", "string");
        enumSchema.put(this.zdlBusinessEntityProperty, enumValue.get("name"));
        if (enumValue.get("comment") != null) {
            enumSchema.put("description", enumValue.get("comment"));
        }
        List values = (List)JSONPath.get(enumValue, "$.values..name");
        enumSchema.put("enum", values);
        return enumSchema;
    }

    public Map<String, Object> convertEntityToSchema(Map<String, Object> entity, Map<String, Object> zdlModel) {
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        schema.put("type", "object");
        schema.put(this.zdlBusinessEntityProperty, entity.get("name"));
        if (entity.get("comment") != null) {
            schema.put("description", entity.get("comment"));
        }
        ArrayList<String> requiredProperties = new ArrayList<String>();
        schema.put("required", requiredProperties);
        LinkedHashMap<Object, Map> properties = new LinkedHashMap<Object, Map>();
        schema.put("properties", properties);
        if (EntitiesToSchemasConverter.includeIdAndVersion(entity)) {
            properties.put("id", this.idTypeMap());
            if (this.includeVersion) {
                properties.put("version", Maps.of("type", "integer", new Object[0]));
            }
        }
        List<Map> fields = (List<Map>)JSONPath.get(entity, "$.fields[*]");
        String superClassName = (String)JSONPath.get(entity, "$.options.extends");
        if (superClassName != null) {
            List superClassFields = (List)JSONPath.get(zdlModel, "$.entities['" + superClassName + "'].fields[*]");
            fields = Lists.concat(superClassFields, fields);
        }
        for (Map field : fields) {
            String pattern;
            String maxlength;
            String minlength;
            boolean isComplexType;
            Map<String, Object> property = new LinkedHashMap<String, Object>();
            boolean bl = isComplexType = JSONPath.get(zdlModel, "$.allEntitiesAndEnums." + field.get("type")) != null || JSONPath.get(zdlModel, "$.events." + field.get("type")) != null;
            if (isComplexType) {
                property.put("$ref", "#/components/schemas/" + field.get("type"));
            } else {
                property.putAll(EntitiesToSchemasConverter.schemaTypeAndFormat((String)field.get("type")));
            }
            String required = (String)JSONPath.get(field, "$.validations.required.value");
            if (required != null) {
                requiredProperties.add((String)field.get("name"));
            }
            if ((minlength = (String)JSONPath.get(field, "$.validations.minlength.value")) != null) {
                property.put("minLength", EntitiesToSchemasConverter.asNumber(minlength));
            }
            if ((maxlength = (String)JSONPath.get(field, "$.validations.maxlength.value")) != null) {
                property.put("maxLength", EntitiesToSchemasConverter.asNumber(maxlength));
            }
            if ((pattern = (String)JSONPath.get(field, "$.validations.pattern.value")) != null) {
                property.put("pattern", pattern);
            }
            if (field.get("comment") != null && !isComplexType) {
                property.put("description", field.get("comment"));
            }
            if (field.get("isArray") == Boolean.TRUE) {
                property = Maps.of("type", "array", "items", property);
            }
            properties.put((String)field.get("name"), property);
        }
        List<Map> relationships = JSONPath.get(entity, "$.relationships[*]", Collections.emptyList());
        if (superClassName != null) {
            List superClassRelationships = (List)JSONPath.get(zdlModel, "$.entities['" + superClassName + "'].relationships[*]");
            relationships = Lists.concat(superClassRelationships, relationships);
        }
        for (Map relationship : relationships) {
            boolean isCollection;
            if (relationship.get("fieldName") == null || !relationship.getOrDefault("ownerSide", false).booleanValue()) continue;
            String fieldName = (String)relationship.get("fieldName");
            boolean isAddRelationshipById = this.isAddRelationshipById(relationship);
            boolean bl = isCollection = relationship.get("isCollection") == Boolean.TRUE;
            if (isAddRelationshipById) {
                if (isCollection) {
                    properties.put(fieldName + "Id", Map.of("type", "array", "items", this.idTypeMap()));
                } else {
                    properties.put(fieldName + "Id", this.idTypeMap());
                }
            }
            Map<String, Object> property = new LinkedHashMap<String, CallSite>();
            if (relationship.get("comment") != null || isAddRelationshipById) {
                String string = isAddRelationshipById ? "(read-only) " : "";
            }
            property.put("$ref", (CallSite)((Object)("#/components/schemas/" + relationship.get("otherEntityName"))));
            if (isCollection) {
                property = Maps.of("type", "array", "items", property);
            }
            properties.put(fieldName, property);
        }
        if (requiredProperties.size() == 0) {
            schema.remove("required");
        }
        return schema;
    }

    public static Map<String, Object> schemaTypeAndFormat(String entityType) {
        LinkedHashMap<String, Object> property = new LinkedHashMap<String, Object>();
        if ("String".equals(entityType) || "TextBlob".equals(entityType)) {
            property.put("type", "string");
        } else if ("Enum".equals(entityType)) {
            property.put("type", "string");
        } else if ("LocalDate".equals(entityType)) {
            property.put("type", "string");
            property.put("format", "date");
        } else if ("ZonedDateTime".equals(entityType)) {
            property.put("type", "string");
            property.put("format", "date-time");
        } else if ("Instant".equals(entityType)) {
            property.put("type", "string");
            property.put("format", "date-time");
        } else if ("Duration".equals(entityType)) {
            property.put("type", "string");
        } else if ("Integer".equals(entityType) || "int".equals(entityType)) {
            property.put("type", "integer");
            property.put("format", "int32");
        } else if ("Long".equals(entityType) || "long".equals(entityType)) {
            property.put("type", "integer");
            property.put("format", "int64");
        } else if ("Float".equals(entityType) || "float".equals(entityType)) {
            property.put("type", "number");
            property.put("format", "float");
        } else if ("Double".equals(entityType) || "double".equals(entityType) || "BigDecimal".equals(entityType)) {
            property.put("type", "number");
            property.put("format", "double");
        } else if ("Boolean".equals(entityType) || "boolean".equals(entityType)) {
            property.put("type", "boolean");
        } else if ("UUID".equals(entityType)) {
            property.put("type", "string");
            property.put("pattern", "^[a-f\\d]{4}(?:[a-f\\d]{4}-){4}[a-f\\d]{12}$");
        } else if (ZDLParser.blobTypes.contains(entityType)) {
            property.put("type", "string");
            property.put("format", "binary");
        } else if ("Map".equals(entityType)) {
            property.put("type", "object");
            property.put("additionalProperties", false);
        } else {
            property.put("type", "string");
        }
        if (property.get("initialValue") != null) {
            property.put("default", property.get("initialValue"));
        }
        return property;
    }

    private static boolean includeIdAndVersion(Map<String, Object> entity) {
        return "entities".equals(entity.get("type")) && JSONPath.get(entity, "options.embedded", false) == false;
    }

    public boolean isAddRelationshipById(Object relationship) {
        boolean isOwnerSide = JSONPath.get(relationship, "ownerSide", false);
        String relationType = (String)JSONPath.get(relationship, "type");
        return "ManyToOne".contentEquals(relationType) && isOwnerSide;
    }

    private static Object asNumber(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return number;
        }
    }
}

