/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.parsers;

import io.zenwave360.jsonrefparser.;
import io.zenwave360.sdk.doc.DocumentedOption;
import io.zenwave360.sdk.parsers.Model;
import io.zenwave360.sdk.parsers.Parser;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultYamlParser
implements Parser {
    @DocumentedOption(description="API Specification File")
    public URI specFile;
    public String targetProperty = "api";
    private ClassLoader projectClassLoader;

    @Override
    public DefaultYamlParser withProjectClassLoader(ClassLoader projectClassLoader) {
        this.projectClassLoader = projectClassLoader;
        return this;
    }

    public DefaultYamlParser withSpecFile(URI specFile) {
        this.specFile = specFile;
        return this;
    }

    public DefaultYamlParser withSpecFile(File specFile) {
        this.specFile = specFile.getAbsoluteFile().toURI();
        return this;
    }

    public DefaultYamlParser withTargetProperty(String targetProperty) {
        this.targetProperty = targetProperty;
        return this;
    }

    @Override
    public Map<String, Object> parse() throws IOException {
        .RefParser parser = new .RefParser(this.specFile).withResourceClassLoader(this.projectClassLoader).withOptions(new .RefParserOptions().withOnCircular(.RefParserOptions.OnCircular.SKIP).withOnMissing(.RefParserOptions.OnMissing.SKIP));
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        model.put(this.targetProperty, new Model(this.specFile, parser.parse().dereference().mergeAllOf().getRefs()));
        return model;
    }
}

