/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.parsers;

import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.zenwave360.sdk.doc.DocumentedOption;
import io.zenwave360.sdk.parsers.Parser;
import io.zenwave360.sdk.utils.Maps;
import java.io.IOException;
import java.net.URI;
import java.util.Map;

public class GraphQLParser
implements Parser {
    @DocumentedOption(description="API Specification File")
    public URI specFile;
    public String targetProperty = "graphql";
    private ClassLoader projectClassLoader;

    @Override
    public GraphQLParser withProjectClassLoader(ClassLoader projectClassLoader) {
        this.projectClassLoader = projectClassLoader;
        return this;
    }

    @Override
    public Map<String, Object> parse() throws IOException {
        SchemaParser schemaParser = new SchemaParser();
        TypeDefinitionRegistry typeDefinitionRegistry = schemaParser.parse(this.loadSpecFile(this.specFile.toString()));
        Map<String, TypeDefinitionRegistry> graphql = Maps.of("typeDefinitionRegistry", typeDefinitionRegistry, "objectTypeExtensions", typeDefinitionRegistry.objectTypeExtensions(), "interfaceTypeExtensions", typeDefinitionRegistry.interfaceTypeExtensions(), "unionTypeExtensions", typeDefinitionRegistry.unionTypeExtensions(), "enumTypeExtensions", typeDefinitionRegistry.enumTypeExtensions(), "scalarTypeExtensions", typeDefinitionRegistry.scalarTypeExtensions(), "inputObjectTypeExtensions", typeDefinitionRegistry.inputObjectTypeExtensions(), "types", typeDefinitionRegistry.types(), "scalars", typeDefinitionRegistry.scalars(), "schema", typeDefinitionRegistry.schemaDefinition());
        return Maps.of(this.targetProperty, graphql, new Object[0]);
    }
}

