/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.parsers;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;

public interface Parser {
    public Parser withProjectClassLoader(ClassLoader var1);

    public Map<String, Object> parse() throws IOException;

    default public String loadSpecFile(String specFile) {
        if (specFile.startsWith("classpath:")) {
            try {
                return new String(this.getClass().getClassLoader().getResourceAsStream(specFile.replaceFirst("classpath:", "")).readAllBytes(), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return Files.readString(Paths.get(specFile, new String[0]), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(Throwable t) {
            super(t);
        }
    }

    public static class ParseProblemsException
    extends RuntimeException {
        final List<Object> problems;

        public ParseProblemsException(List<Object> problems) {
            this.problems = problems;
        }
    }
}

