/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.parsers;

import io.github.zenwave360.zdl.ZdlParser;
import io.github.zenwave360.zdl.antlr.ZdlModel;
import io.zenwave360.sdk.doc.DocumentedOption;
import io.zenwave360.sdk.parsers.Parser;
import io.zenwave360.sdk.utils.JSONPath;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ZDLParser
implements Parser {
    public static final List blobTypes = List.of("Blob", "AnyBlob", "ImageBlob", "byte");
    @DocumentedOption(description="ZDL files to parse")
    public String[] specFiles;
    private String content;
    public String targetProperty = "zdl";
    @DocumentedOption(description="Continue even when ZDL contains fatal errors")
    public boolean continueOnZdlError = true;
    public Map<String, String> options = new HashMap<String, String>();
    private ClassLoader projectClassLoader;

    @DocumentedOption(description="ZDL file to parse")
    public void setSpecFile(String specFile) {
        this.specFiles = specFile == null ? new String[0] : new String[]{specFile};
    }

    public ZDLParser withSpecFile(String ... specFile) {
        this.specFiles = specFile;
        return this;
    }

    public ZDLParser withContent(String content) {
        this.content = content;
        return this;
    }

    public ZDLParser withTargetProperty(String targetProperty) {
        this.targetProperty = targetProperty;
        return this;
    }

    public ZDLParser withOptions(String option, String value) {
        this.options.put(option, value);
        return this;
    }

    @Override
    public ZDLParser withProjectClassLoader(ClassLoader projectClassLoader) {
        this.projectClassLoader = projectClassLoader;
        return this;
    }

    @Override
    public Map<String, Object> parse() throws IOException {
        ZdlModel zdlModel;
        List<Object> problems;
        String zdlString = this.content;
        if (zdlString == null) {
            zdlString = Arrays.stream(this.specFiles).map(this::loadSpecFile).collect(Collectors.joining());
        }
        if (!(problems = JSONPath.get(zdlModel = new ZdlParser().parseModel(zdlString), "$.problems", List.of())).isEmpty()) {
            for (Object e : problems) {
                Object message = JSONPath.get(e, "message");
                int[] location = JSONPath.get(e, "location", new int[5]);
                Object path = JSONPath.get(e, "path");
                System.err.printf("ZDL ERROR [%s]: %s [line: %s, char: %s]%n", path, message, location[2], location[3] + 1);
            }
            if (!this.continueOnZdlError) {
                throw new Parser.ParseProblemsException(problems);
            }
        }
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        model.put(this.targetProperty, zdlModel);
        return model;
    }
}

