/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.plugins;

import io.zenwave360.sdk.doc.DocumentedOption;
import io.zenwave360.sdk.generators.Generator;
import io.zenwave360.sdk.templating.TemplateOutput;
import io.zenwave360.sdk.utils.NamingUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForkPluginGenerator
implements Generator {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @DocumentedOption(description="Plugin Configuration class to fork", required=true)
    public String sourcePluginClassName;
    @DocumentedOption(description="New Plugin Configuration class. It will be used for class name, package and maven groupId.", required=true)
    public String targetPluginClassName;
    @DocumentedOption(description="Download URL for the source code of original plugin in zip format", required=false)
    public URL downloadURL = new URL("https://github.com/ZenWave360/zenwave-sdk/archive/refs/tags/v1.4.0.zip");
    @DocumentedOption
    public String targetFolder;
    final Pattern packageClassSplitPattern = Pattern.compile("(.*)\\.(\\w+)", 8);
    final Pattern groupIdPattern = Pattern.compile("^(\\s*)<groupId>.*<\\/groupId>", 8);
    final Pattern artifactIdPattern = Pattern.compile("^(\\s*)<artifactId>.*<\\/artifactId>", 8);

    @Override
    public List<TemplateOutput> generate(Map<String, Object> contextModel) {
        try {
            File zipFile = this.download(this.downloadURL);
            File repoDirectory = this.uncompress(zipFile);
            File javaFile = this.findJavaFileInFolder(repoDirectory, this.sourcePluginClassName);
            File mavenModuleFile = this.findMavenModuleRootFolder(javaFile);
            File targetFolderFile = new File(this.targetFolder);
            this.copyFolders(mavenModuleFile, targetFolderFile);
            this.renameArtifactAndGroupId(new File(targetFolderFile, "pom.xml"), this.sourcePluginClassName, this.targetPluginClassName);
            this.movePackageFolders(targetFolderFile, this.sourcePluginClassName, this.targetPluginClassName);
            this.deleteEmptyFolders(targetFolderFile);
            this.searchAndReplace(targetFolderFile, this.sourcePluginClassName, this.targetPluginClassName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.emptyList();
    }

    protected void copyFolders(File source, File target) throws IOException {
        this.log.debug("Copying {} to {}", (Object)source, (Object)target);
        target.mkdirs();
        FileUtils.copyDirectory((File)source, (File)target);
    }

    protected void movePackageFolders(File folder, String sourcePluginClassName, String targetPluginClassName) throws IOException {
        this.log.debug("Renaming packages from {} to {}", (Object)sourcePluginClassName, (Object)targetPluginClassName);
        String[] sourcePackageAndClass = this.splitPackageAndClass(sourcePluginClassName);
        String[] targetPackageAndClass = this.splitPackageAndClass(targetPluginClassName);
        File srcFolder = new File(folder, "src/main/java");
        File testsFolder = new File(folder, "src/test/java");
        File resourcesFolder = new File(folder, "src/main/resources");
        File testsResourcesFolder = new File(folder, "src/main/resources");
        String sourcePackageDir = sourcePackageAndClass[0].replaceAll("\\.", "/");
        String targetPackageDir = targetPackageAndClass[0].replaceAll("\\.", "/");
        File sourcePackageFolder = new File(srcFolder, sourcePackageDir);
        File targetPackageFolder = new File(srcFolder, targetPackageDir);
        File sourcePackageTestsFolder = new File(testsFolder, sourcePackageDir);
        File targetPackageTestsFolder = new File(testsFolder, targetPackageDir);
        File sourceResourcesPackageFolder = new File(resourcesFolder, sourcePackageDir);
        File targetResourcesPackageFolder = new File(resourcesFolder, targetPackageDir);
        File sourceTestsResourcesPackageFolder = new File(testsResourcesFolder, sourcePackageDir);
        File targetTestsResourcesPackageFolder = new File(testsResourcesFolder, targetPackageDir);
        targetPackageFolder.mkdirs();
        Collection javaFiles = FileUtils.listFiles((File)sourcePackageFolder, (String[])new String[]{"java"}, (boolean)true);
        for (Object javaFile : javaFiles) {
            this.log.debug("Moving {} to folder {}", javaFile, (Object)targetPackageFolder);
            String relativeFileName = this.asRelative(sourcePackageFolder.getPath(), ((File)javaFile).getPath());
            relativeFileName = this.renameTargetClass(relativeFileName, sourcePackageAndClass[1], targetPackageAndClass[1]);
            this.moveFile((File)javaFile, new File(targetPackageFolder, relativeFileName));
        }
        targetPackageTestsFolder.mkdirs();
        Collection testFiles = FileUtils.listFiles((File)sourcePackageTestsFolder, null, (boolean)true);
        for (Object testFile : testFiles) {
            this.log.debug("Moving {} to folder {}", testFile, (Object)targetPackageTestsFolder);
            String relativeFileName = this.asRelative(sourcePackageTestsFolder.getPath(), ((File)testFile).getPath());
            relativeFileName = this.renameTargetClass(relativeFileName, sourcePackageAndClass[1], targetPackageAndClass[1]);
            this.moveFile((File)testFile, new File(targetPackageTestsFolder, relativeFileName));
        }
        targetResourcesPackageFolder.mkdirs();
        Collection resourceFiles = FileUtils.listFiles((File)sourceResourcesPackageFolder, null, (boolean)true);
        for (File resourceFile : resourceFiles) {
            this.log.debug("Moving {} to folder {}", (Object)resourceFile, (Object)targetResourcesPackageFolder);
            String relativeFileName = this.asRelative(sourceResourcesPackageFolder.getPath(), resourceFile.getPath());
            relativeFileName = this.renameTargetClass(relativeFileName, sourcePackageAndClass[1], targetPackageAndClass[1]);
            this.moveFile(resourceFile, new File(targetResourcesPackageFolder, relativeFileName));
        }
        targetTestsResourcesPackageFolder.mkdirs();
        Collection testsResourceFiles = FileUtils.listFiles((File)sourceTestsResourcesPackageFolder, null, (boolean)true);
        for (File testsResourceFile : testsResourceFiles) {
            this.log.debug("Moving {} to folder {}", (Object)testsResourceFile, (Object)targetTestsResourcesPackageFolder);
            String relativeFileName = this.asRelative(sourceTestsResourcesPackageFolder.getPath(), testsResourceFile.getPath());
            relativeFileName = this.renameTargetClass(relativeFileName, sourcePackageAndClass[1], targetPackageAndClass[1]);
            this.moveFile(testsResourceFile, new File(targetTestsResourcesPackageFolder, relativeFileName));
        }
    }

    private void moveFile(File src, File target) throws IOException {
        if (src.equals(target)) {
            this.log.debug("Skip moving file to itself {}", (Object)src);
            return;
        }
        FileUtils.moveFile((File)src, (File)target);
    }

    private String asRelative(String root, String nested) {
        return nested.replace(root + File.separator, "");
    }

    private String renameTargetClass(String relativeFileName, String sourceClass, String targetClass) {
        String prefix = relativeFileName.contains(File.separator) ? File.separator : "";
        return relativeFileName.replace(prefix + sourceClass + ".java", prefix + targetClass + ".java");
    }

    private void searchAndReplace(File targetFolderFile, String sourcePluginClassName, String targetPluginClassName) throws IOException {
        String[] sourcePackageAndClass = this.splitPackageAndClass(sourcePluginClassName);
        String[] targetPackageAndClass = this.splitPackageAndClass(targetPluginClassName);
        List<Pair<String, String>> replacements = List.of(Pair.of((Object)sourcePackageAndClass[0], (Object)targetPackageAndClass[0]), Pair.of((Object)sourcePackageAndClass[1], (Object)targetPackageAndClass[1]), Pair.of((Object)sourcePluginClassName.replaceAll("\\.", "/"), (Object)targetPluginClassName.replaceAll("\\.", "/")), Pair.of((Object)sourcePackageAndClass[0].replaceAll("\\.", "/"), (Object)targetPackageAndClass[0].replaceAll("\\.", "/")));
        this.log.debug("Replacing packages and class names in files {}", replacements);
        this.searchAndReplaceInFolder(targetFolderFile, replacements);
    }

    protected void searchAndReplaceInFolder(File root, List<Pair<String, String>> replacements) throws IOException {
        for (File file : root.listFiles()) {
            if (file.isDirectory()) {
                this.searchAndReplaceInFolder(file, replacements);
                continue;
            }
            if (!file.isFile() || file.getName().contentEquals("pom.xml")) continue;
            this.searchAndReplaceInFile(file, replacements);
        }
    }

    protected void searchAndReplaceInFile(File file, List<Pair<String, String>> replacements) throws IOException {
        String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        for (Pair<String, String> replacement : replacements) {
            content = StringUtils.replace((String)content, (String)((String)replacement.getKey()), (String)((String)replacement.getValue()));
        }
        FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.UTF_8);
    }

    protected void renameArtifactAndGroupId(File pomFile, String sourcePluginClassName, String targetPluginClassName) throws IOException {
        this.log.debug("Renaming artifactId and groupId in pom {}", (Object)pomFile);
        String[] sourcePackageAndClass = this.splitPackageAndClass(sourcePluginClassName);
        String[] targetPackageAndClass = this.splitPackageAndClass(targetPluginClassName);
        String targetArtifactId = NamingUtils.kebabCase(targetPackageAndClass[1]).replace("-configuration", "");
        String pom = Files.readString(Path.of(pomFile.toURI()));
        String artifactIdMatch = this.findMatchWithShorterIndent(pom, this.artifactIdPattern);
        String groupIdMatch = this.findMatchWithShorterIndent(pom, this.groupIdPattern);
        pom = this.replaceLine(pom, artifactIdMatch, "    <artifactId>" + targetArtifactId + "</artifactId>");
        pom = this.replaceLine(pom, groupIdMatch, "    <groupId>" + targetPackageAndClass[0] + "</groupId>");
        Files.writeString(Path.of(pomFile.toURI()), (CharSequence)pom, new OpenOption[0]);
    }

    public String replaceLine(String value, String regex, String replacement) {
        return Pattern.compile("^" + regex.replace("/", "\\/") + "$", 8).matcher(value).replaceAll(replacement);
    }

    private String[] splitPackageAndClass(String fullClassName) {
        Matcher matcher = this.packageClassSplitPattern.matcher(fullClassName);
        if (matcher.find()) {
            return new String[]{matcher.group(1), matcher.group(2)};
        }
        return new String[2];
    }

    private String findMatchWithShorterIndent(String pom, Pattern pattern) {
        String shorterMatch = null;
        int shorterIndent = Integer.MAX_VALUE;
        Matcher matcher = pattern.matcher(pom);
        while (matcher.find()) {
            int indent = matcher.group(1).replaceAll("\t", "  ").length();
            if (indent >= shorterIndent) continue;
            shorterIndent = indent;
            shorterMatch = matcher.group();
        }
        return shorterMatch;
    }

    protected File findMavenModuleRootFolder(File file) {
        File pomFile = new File(file, "pom.xml");
        if (pomFile.exists()) {
            this.log.debug("Found maven module root at {}", (Object)pomFile.getParentFile());
            return pomFile.getParentFile();
        }
        if (file.getParentFile().exists()) {
            return this.findMavenModuleRootFolder(file.getParentFile());
        }
        return null;
    }

    protected File findJavaFileInFolder(File repoDirectory, String javaClassName) {
        File javaFile = new File(repoDirectory, "src/main/java/" + javaClassName.replace('.', '/') + ".java");
        if (javaFile.exists()) {
            return javaFile;
        }
        for (File file : repoDirectory.listFiles()) {
            if (!file.isDirectory() || (javaFile = this.findJavaFileInFolder(file, javaClassName)) == null) continue;
            return javaFile;
        }
        return null;
    }

    protected void deleteEmptyFolders(File root) throws IOException {
        List files = Files.walk(root.toPath(), new FileVisitOption[0]).sorted().collect(Collectors.toList());
        Collections.reverse(files);
        for (Path path : files) {
            if (!Files.isDirectory(path, new LinkOption[0]) || Files.list(path).count() != 0L) continue;
            Files.delete(path);
        }
    }

    protected File download(URL downloadURL) throws IOException {
        File zipFile = File.createTempFile("zenwave-sdk-repo-", ".zip");
        this.log.debug("Downloading {} to {}", (Object)downloadURL, (Object)zipFile.getAbsoluteFile());
        FileUtils.copyURLToFile((URL)downloadURL, (File)zipFile);
        return zipFile;
    }

    protected File uncompress(File zipFile) throws IOException {
        File outputDir = File.createTempFile("zenwave-sdk-repo-", "");
        outputDir.delete();
        outputDir.mkdir();
        this.log.debug("Uncompressing {} to {}", (Object)zipFile, (Object)outputDir);
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            File newFile = this.newFile(outputDir, zipEntry);
            if (zipEntry.isDirectory()) {
                if (!newFile.isDirectory() && !newFile.mkdirs()) {
                    throw new IOException("Failed to create directory " + newFile);
                }
            } else {
                int len;
                File parent = newFile.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("Failed to create directory " + parent);
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        return outputDir;
    }

    private File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }
}

