/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.plugins;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.zenwave360.sdk.Plugin;
import io.zenwave360.sdk.doc.DocumentedPlugin;
import io.zenwave360.sdk.parsers.ZDLParser;
import io.zenwave360.sdk.processors.Processor;
import io.zenwave360.sdk.processors.ZDLProcessor;
import java.util.Map;

@DocumentedPlugin(value="Prints to StdOut ZDL Model as JSON", shortCode="zdl-to-json")
public class ZdlToJsonPlugin
extends Plugin
implements Processor {
    public ZdlToJsonPlugin() {
        this.withChain(ZDLParser.class, ZDLProcessor.class, ZdlToJsonPlugin.class);
    }

    @Override
    public Map<String, Object> process(Map<String, Object> contextModel) {
        Object zdl = contextModel.get("zdl");
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String json = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(zdl);
            System.out.println(json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

