/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.processors;

import io.zenwave360.jsonrefparser.;
import io.zenwave360.sdk.doc.DocumentedOption;
import io.zenwave360.sdk.options.asyncapi.AsyncapiVersionType;
import io.zenwave360.sdk.parsers.Model;
import io.zenwave360.sdk.processors.AbstractBaseProcessor;
import io.zenwave360.sdk.processors.Processor;
import io.zenwave360.sdk.utils.JSONPath;
import io.zenwave360.sdk.utils.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class AsyncApiProcessor
extends AbstractBaseProcessor
implements Processor {
    @DocumentedOption(description="AsyncAPI extension property name for runtime autoconfiguration of headers.")
    public String runtimeHeadersProperty = "x-runtime-expression";

    @Override
    public Map<String, Object> process(Map<String, Object> contextModel) {
        Model apiModel = this.targetProperty != null ? (Model)contextModel.get(this.targetProperty) : (Model)contextModel;
        boolean isV2 = AsyncapiVersionType.isV2(apiModel);
        boolean isV3 = AsyncapiVersionType.isV3(apiModel);
        apiModel.getRefs().getOriginalRefsList().forEach(pair -> {
            if (pair.getValue() instanceof Map) {
                ((Map)pair.getValue()).put("x--original-$ref", ((.Ref)pair.getKey()).getRef());
            }
        });
        List traitsParents = (List)JSONPath.get(apiModel, "$..[?(@.traits)]");
        for (Object traitParent : traitsParents) {
            List list = (List)traitParent.get("traits");
            for (Map map : list) {
                for (Map.Entry trait : map.entrySet()) {
                    String traitName = (String)trait.getKey();
                    if (traitName.startsWith("x--")) continue;
                    if (traitParent.containsKey(traitName)) {
                        Map merged = Maps.deepMerge(Maps.copy((Map)trait.getValue()), (Map)traitParent.get(traitName));
                        traitParent.put(traitName, merged);
                        continue;
                    }
                    traitParent.put(traitName, (Map)trait.getValue());
                }
            }
        }
        Map schemas = JSONPath.get(apiModel, "$.components.schemas", Collections.emptyMap());
        for (Map.Entry entry : schemas.entrySet()) {
            ((Map)entry.getValue()).put("x--schema-name", entry.getKey());
        }
        List resolvedSchemas = (List)JSONPath.get(apiModel, "$..[?(@.x--original-$ref =~ /#\\/components\\/schemas\\/.*/)]");
        for (Object resolvedSchema : resolvedSchemas) {
            if (resolvedSchema.containsKey("x--schema-name")) continue;
            String string = (String)JSONPath.get(resolvedSchema, "$.x--original-$ref");
            resolvedSchema.put("x--schema-name", string.replace("#/components/schemas/", ""));
        }
        Map map = JSONPath.get(apiModel, "$.channels", Collections.emptyMap());
        for (Map.Entry entry : map.entrySet()) {
            Map channel = (Map)entry.getValue();
            if (isV2 && channel != null) {
                this.addChannelNameToOperation((Map)channel.get("publish"), (String)entry.getKey());
                this.addChannelNameToOperation((Map)channel.get("subscribe"), (String)entry.getKey());
                this.addOperationType((Map)channel.get("publish"), "publish");
                this.addOperationType((Map)channel.get("subscribe"), "subscribe");
                this.addNormalizedTagName((Map)channel.get("publish"));
                this.addNormalizedTagName((Map)channel.get("subscribe"));
                this.addOperationIdVariants((Map)channel.get("publish"));
                this.addOperationIdVariants((Map)channel.get("subscribe"));
                this.collectMessages((Map)channel.get("publish"));
                this.collectMessages((Map)channel.get("subscribe"));
                this.setHasRuntimeHeaders((Map)channel.get("publish"));
                this.setHasRuntimeHeaders((Map)channel.get("subscribe"));
            }
            if (!isV3) continue;
            List messages = JSONPath.get(channel, "$.messages[*]", Collections.emptyList());
            channel.put("x--messages", messages);
        }
        if (isV3) {
            Map operations = JSONPath.get(apiModel, "$.operations", Collections.emptyMap());
            for (Map.Entry operationEntry : operations.entrySet()) {
                ((Map)operationEntry.getValue()).put("operationId", operationEntry.getKey());
                this.addOperationIdVariants((Map)operationEntry.getValue());
                this.addNormalizedTagName((Map)operationEntry.getValue());
                ((Map)operationEntry.getValue()).put("x--messages", JSONPath.get(operationEntry.getValue(), "$.channel.x--messages"));
            }
        }
        List messages = (List)JSONPath.get(apiModel, "$.channels..x--messages[*]");
        for (Map message : messages) {
            this.calculateMessageParamType(apiModel, message);
        }
        Map map2 = JSONPath.get(apiModel, "$.components.messages", Collections.emptyMap());
        for (Map.Entry message : map2.entrySet()) {
            if (((Map)message.getValue()).containsKey("name")) continue;
            ((Map)message.getValue()).put("name", message.getKey());
        }
        return contextModel;
    }

    private void addChannelNameToOperation(Map<String, Object> operation, String channelName) {
        if (operation != null) {
            operation.put("x--channel", channelName);
        }
    }

    private void addOperationType(Map<String, Object> operation, String operationType) {
        if (operation != null) {
            operation.put("x--operationType", operationType);
        }
    }

    private void setHasRuntimeHeaders(Map operation) {
        if (operation != null) {
            boolean hasAutoheader;
            boolean bl = hasAutoheader = !JSONPath.get(operation, String.format("$.x--messages..headers..[?(@.%s)]", this.runtimeHeadersProperty), Collections.emptyList()).isEmpty();
            if (hasAutoheader) {
                operation.put("x--has-runtime-headers", true);
            }
        }
    }

    public void collectMessages(Map<String, Object> operation) {
        if (operation != null) {
            Map message = (Map)operation.get("message");
            ArrayList<Map> messages = new ArrayList<Map>();
            if (message.containsKey("oneOf")) {
                messages.addAll((List)message.get("oneOf"));
            } else {
                messages.add(message);
            }
            operation.put("x--messages", messages);
        }
    }

    private String findSchemaFormat(Map<String, Object> apiModel, Map<String, Object> message) {
        Object asyncapiVersion = JSONPath.get(apiModel, "$.asyncapi");
        String defaultSchemaFormat = SchemaFormatType.ASYNCAPI_YAML.getSchemaFormat((String)asyncapiVersion);
        String schemaFormat = (String)ObjectUtils.firstNonNull((Object[])new String[]{(String)JSONPath.getFirst(message, "$.payload.schemaFormat", "$.schemaFormat"), defaultSchemaFormat});
        return this.normalizeSchemaFormat(schemaFormat);
    }

    public void calculateMessageParamType(Map<String, Object> apiModel, Map<String, Object> message) {
        String schemaFormat = this.findSchemaFormat(apiModel, message);
        Object javaType = null;
        if ("avro".equals(schemaFormat)) {
            String name = (String)JSONPath.getFirst(message, "$.payload.schema.name", "$.payload.name");
            String namespace = (String)JSONPath.getFirst(message, "$.payload.schema.namespace", "$.payload.namespace");
            javaType = namespace + "." + name;
        }
        if ("jsonSchema".equals(schemaFormat)) {
            javaType = (String)JSONPath.getFirst(message, "$.payload.schema.javaType", "$.payload.javaType");
        }
        if (("asyncapi".equals(schemaFormat) || "openapi".equals(schemaFormat)) && (javaType = this.normalizeTagName((String)JSONPath.getFirst(message, "$.payload.schema.x--schema-name", "$.payload.x--schema-name"))) == null) {
            javaType = this.normalizeTagName((String)message.getOrDefault("x-javaType", message.getOrDefault("messageId", message.get("name"))));
        }
        if (javaType != null) {
            message.put("x--javaType", javaType);
            message.put("x--javaTypeSimpleName", ((String)javaType).substring(((String)javaType).lastIndexOf(".") + 1));
        }
    }

    private String normalizeSchemaFormat(String schemaFormat) {
        if (schemaFormat == null) {
            return "asyncapi";
        }
        if (schemaFormat.matches("application\\/vnd\\.aai\\.asyncapi(\\+json|\\+yaml)*;version=[\\d.]+")) {
            return "asyncapi";
        }
        if (schemaFormat.matches("application\\/vnd\\.oai\\.openapi(\\+json|\\+yaml)*;version=[\\d.]+")) {
            return "openapi";
        }
        if (schemaFormat.matches("application\\/schema(\\+json|\\+yaml)*;version=draft-\\d+")) {
            return "jsonSchema";
        }
        if (schemaFormat.matches("application\\/vnd\\.apache\\.avro(\\+json|\\+yaml)*;version=[\\d.]+")) {
            return "avro";
        }
        return null;
    }

    public static enum SchemaFormatType {
        ASYNCAPI("application/vnd.aai.asyncapi;"),
        ASYNCAPI_JSON("application/vnd.aai.asyncapi+json;"),
        ASYNCAPI_YAML("application/vnd.aai.asyncapi+yaml;"),
        OPENAPI("application/vnd.oai.openapi;"),
        OPENAPI_JSON("application/vnd.oai.openapi+json;"),
        OPENAPI_YAML("application/vnd.oai.openapi+yaml;"),
        JSONSCHEMA_JSON("application/schema+json;"),
        JSONSCHEMA_YAML("application/schema+yaml;"),
        AVRO("application/vnd.apache.avro;"),
        AVRO_JSON("application/vnd.apache.avro+json;"),
        AVRO_YAML("application/vnd.apache.avro+yaml;");

        private static final List<SchemaFormatType> ASYNCAPI_ALL;
        private static final List<SchemaFormatType> OPENAPI_ALL;
        private static final List<SchemaFormatType> JSONSCHEMA_ALL;
        private static final List<SchemaFormatType> AVRO_ALL;
        private static final List<SchemaFormatType> YAML_ALL;
        private String schemaFormatPrefix;

        private SchemaFormatType(String regex) {
            this.schemaFormatPrefix = regex;
        }

        public static boolean isSchemaFormat(SchemaFormatType formatType) {
            return formatType == null || ASYNCAPI_ALL.contains((Object)formatType) || OPENAPI_ALL.contains((Object)formatType);
        }

        public static boolean isJsonSchemaFormat(SchemaFormatType formatType) {
            return JSONSCHEMA_ALL.contains((Object)formatType);
        }

        public static boolean isAvroFormat(SchemaFormatType formatType) {
            return AVRO_ALL.contains((Object)formatType);
        }

        public static boolean isNativeFormat(SchemaFormatType formatType) {
            return SchemaFormatType.isSchemaFormat(formatType);
        }

        public static boolean isYamlFormat(SchemaFormatType formatType) {
            return YAML_ALL.contains((Object)formatType);
        }

        public static SchemaFormatType getFormat(String schemaFormatString) {
            if (schemaFormatString == null) {
                return ASYNCAPI_YAML;
            }
            for (SchemaFormatType schemaFormat : SchemaFormatType.values()) {
                if (!schemaFormatString.startsWith(schemaFormat.schemaFormatPrefix)) continue;
                return schemaFormat;
            }
            return null;
        }

        public String getSchemaFormat(String asyncApiVersion) {
            return this.schemaFormatPrefix + "version=" + asyncApiVersion;
        }

        static {
            ASYNCAPI_ALL = Arrays.asList(ASYNCAPI, ASYNCAPI_JSON, ASYNCAPI_YAML);
            OPENAPI_ALL = Arrays.asList(OPENAPI, OPENAPI_JSON, OPENAPI_YAML);
            JSONSCHEMA_ALL = Arrays.asList(JSONSCHEMA_JSON, JSONSCHEMA_YAML);
            AVRO_ALL = Arrays.asList(AVRO, AVRO_JSON, AVRO_YAML);
            YAML_ALL = Arrays.asList(ASYNCAPI_YAML, OPENAPI_YAML, JSONSCHEMA_YAML, AVRO_YAML);
        }
    }
}

