/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.processors;

import io.zenwave360.jsonrefparser.;
import io.zenwave360.sdk.parsers.Model;
import io.zenwave360.sdk.processors.AbstractBaseProcessor;
import io.zenwave360.sdk.processors.Processor;
import io.zenwave360.sdk.utils.JSONPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpenApiProcessor
extends AbstractBaseProcessor
implements Processor {
    @Override
    public Map<String, Object> process(Map<String, Object> contextModel) {
        Model apiModel = this.targetProperty != null ? (Model)contextModel.get(this.targetProperty) : (Model)contextModel;
        apiModel.getRefs().getOriginalRefsList().forEach(pair -> {
            if (pair.getValue() instanceof Map) {
                ((Map)pair.getValue()).put("x--original-$ref", ((.Ref)pair.getKey()).getRef());
            }
        });
        List<Object> parametersParents = JSONPath.get(apiModel, "$.paths[*][?(@.parameters)]", Collections.emptyList());
        for (Object parametersParent : parametersParents) {
            List list = (List)parametersParent.remove("parameters");
            for (Object v : parametersParent.values()) {
                this.addParentParametersToOperation((Map)v, list);
            }
        }
        Map paths = JSONPath.get(apiModel, "$.paths", Collections.emptyMap());
        for (Map.Entry entry : paths.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                this.addPathNameToOperation((Map)entry2.getValue(), (String)entry.getKey());
                this.addHttpVerbToOperation((Map)entry2.getValue(), (String)entry2.getKey());
                this.addNormalizedTagName((Map)entry2.getValue());
                this.addOperationIdVariants((Map)entry2.getValue());
            }
        }
        List operations = (List)JSONPath.get(apiModel, "$.paths[*][*][?(@.operationId)]");
        for (Object operation : operations) {
            this.prepareOperationRequestInfo(apiModel, (Map<String, Object>)operation);
            this.simplifyOperationResponseInfo(apiModel, (Map<String, Object>)operation);
        }
        Map map = JSONPath.get(apiModel, "$.components.schemas", Collections.emptyMap());
        for (Map.Entry entry : map.entrySet()) {
            ((Map)entry.getValue()).put("x--schema-name", entry.getKey());
        }
        List properties = (List)JSONPath.get(apiModel, "$.components.schemas..[?(@.properties)].properties");
        for (Map property : properties) {
            for (Map.Entry entry : property.entrySet()) {
                if (!(entry.getValue() instanceof Map)) continue;
                ((Map)entry.getValue()).put("x--property-name", entry.getKey());
            }
        }
        return contextModel;
    }

    private void addPathNameToOperation(Map<String, Object> operation, String path) {
        if (operation != null) {
            operation.put("x--path", path);
        }
    }

    private void addHttpVerbToOperation(Map<String, Object> operation, String operationType) {
        if (operation != null) {
            operation.put("x--httpVerb", operationType);
        }
    }

    private void addParentParametersToOperation(Map<String, Object> operation, List<Map<String, Object>> parentParameters) {
        if (operation != null && parentParameters != null && !parentParameters.isEmpty()) {
            if (!operation.containsKey("parameters")) {
                operation.put("parameters", new ArrayList());
            }
            List parameters = (List)operation.get("parameters");
            parameters.addAll(parentParameters);
        }
    }

    private void prepareOperationRequestInfo(Model apiModel, Map<String, Object> operation) {
        Map requestBodySchema = (Map)JSONPath.get(operation, "$.requestBody.content['application/json'].schema");
        if (requestBodySchema != null) {
            .Ref ref = apiModel.getRefs().getOriginalRef((Object)requestBodySchema);
            operation.put("x--content-type", "application/json");
            operation.put("x--request-dto", this.getDtoName(ref));
            operation.put("x--request-schema", requestBodySchema);
        }
    }

    private void simplifyOperationResponseInfo(Model apiModel, Map<String, Object> operation) {
        Map responses = (Map)JSONPath.get(operation, "$.responses");
        if (responses != null) {
            operation.put("x--response", this.getSimplifiedResponseInfo(apiModel, (Map.Entry)responses.entrySet().stream().findFirst().get()));
            for (Map.Entry<String, Map<String, Object>> entry : responses.entrySet()) {
                Map<String, Object> simplified = this.getSimplifiedResponseInfo(apiModel, entry);
                entry.getValue().putAll(simplified);
            }
        }
    }

    private Map<String, Object> getSimplifiedResponseInfo(Model apiModel, Map.Entry<String, Map<String, Object>> response) {
        HashMap<String, Object> simplified = new HashMap<String, Object>();
        simplified.put("x--statusCode", response.getKey());
        Map responseBodySchema = (Map)JSONPath.get(response.getValue(), "$.content['application/json'].schema");
        if (responseBodySchema != null) {
            .Ref ref = apiModel.getRefs().getOriginalRef((Object)responseBodySchema);
            simplified.put("x--content-type", "application/json");
            simplified.put("x--response-schema", responseBodySchema);
            simplified.put("x--response-dto", this.getDtoName(ref));
        }
        return simplified;
    }

    private String getDtoName(.Ref ref) {
        if (ref != null) {
            return ref.getRef().replace("#/components/schemas/", "");
        }
        return null;
    }
}

