/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.processors;

import io.zenwave360.sdk.processors.AbstractBaseProcessor;
import io.zenwave360.sdk.utils.JSONPath;
import io.zenwave360.sdk.utils.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZDL2JDLProcessor
extends AbstractBaseProcessor {
    public ZDL2JDLProcessor() {
        this.targetProperty = "zdl";
    }

    @Override
    public Map<String, Object> process(Map<String, Object> contextModel) {
        boolean withElasticsearch;
        Map model = this.targetProperty != null ? (Map)contextModel.get(this.targetProperty) : contextModel;
        Map services = Maps.copy((Map)JSONPath.get(model, "$.services"));
        for (Map service : services.values()) {
            service.put("entityNames", service.get("aggregates"));
            service.put("value", service.get("name"));
            service.put("name", "service");
            List entityNames = (List)service.get("aggregates");
            for (Object entityName : entityNames) {
                Object entity = JSONPath.get(model, "$.entities['" + entityName + "']");
                if (entity == null) continue;
                HashMap options = JSONPath.get(entity, "$.options", new HashMap());
                options.put("service", service.get("name"));
                JSONPath.set(entity, "$.options", options);
            }
        }
        model.put("options", Maps.of("options", Maps.of("service", services, new Object[0]), new Object[0]));
        boolean bl = withElasticsearch = !JSONPath.get(model, "$.entities[*].options.search", List.of()).isEmpty();
        if (withElasticsearch) {
            JSONPath.set(model, "$.options.options.search", true);
        }
        List enums = JSONPath.get(model, "$.enums[*].name", List.of());
        List entities = JSONPath.get(model, "$.entities[*].name", List.of());
        List fields = JSONPath.get(model, "$.entities[*].fields.[*]", List.of());
        for (Object field : fields) {
            Object fieldType = JSONPath.get(field, "$.type");
            if (enums.contains(fieldType)) {
                JSONPath.set(field, "$.isEnum", true);
            }
            if (!entities.contains(fieldType)) continue;
            JSONPath.set(field, "$.isEntity", true);
        }
        return contextModel;
    }
}

