/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.processors;

import io.zenwave360.sdk.processors.AbstractBaseProcessor;
import io.zenwave360.sdk.processors.ZDL2JDLProcessor;
import io.zenwave360.sdk.utils.JSONPath;
import io.zenwave360.sdk.utils.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZDLProcessor
extends AbstractBaseProcessor {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public ZDLProcessor() {
        this.targetProperty = "zdl";
    }

    @Override
    public Map<String, Object> process(Map<String, Object> contextModel) {
        Map<String, Object> zdlModel;
        Map<String, Object> map = zdlModel = this.targetProperty != null ? (Map<String, Object>)contextModel.get(this.targetProperty) : contextModel;
        if (zdlModel == null) {
            return contextModel;
        }
        this.processServiceName(zdlModel);
        this.processServiceAsyncMethods(zdlModel);
        contextModel = new ZDL2JDLProcessor().process(contextModel);
        List entities = (List)JSONPath.get(zdlModel, "$.entities[*]");
        for (Map entity : entities) {
            if (JSONPath.get(entity, "options.extends") != null) {
                this.fillExtendsEntities(entity, zdlModel);
            }
            if (JSONPath.get(entity, "options.copy") != null) {
                this.fillCopyEntities(entity, zdlModel);
            }
            this.fillEntityRelationships(entity, zdlModel);
        }
        this.processCopyAnnotation(zdlModel);
        return contextModel;
    }

    public void processServiceName(Map<String, Object> zdlModel) {
        Map services = JSONPath.get(zdlModel, "$.services", Map.of());
        for (Map.Entry service : services.entrySet()) {
            List aggregates = JSONPath.get(service.getValue(), "$.aggregates", List.of());
            for (Object aggregate : aggregates) {
                if (JSONPath.get(zdlModel, "$.entities." + aggregate) == null) continue;
                JSONPath.set(zdlModel, "$.entities." + aggregate + ".options.service", service.getKey());
            }
        }
    }

    public void processServiceAsyncMethods(Map<String, Object> zdlModel) {
        List<Map> asyncMethods = JSONPath.get(zdlModel, "$.services[*].methods[*][?(@.options.async)]", List.of());
        for (Map asyncMethod : asyncMethods) {
            String syncMethodName;
            Map service = (Map)JSONPath.get(zdlModel, "$.services." + asyncMethod.get("serviceName"));
            if (JSONPath.get(service, "$.methods." + (syncMethodName = asyncMethod.get("name") + "Sync")) == null) {
                Map syncMethod = Maps.copy(asyncMethod);
                syncMethod.put("name", syncMethodName);
                ((Map)syncMethod.get("options")).remove("async");
                ((List)syncMethod.get("optionsList")).removeIf(o -> "async".equals(((Map)o).get("name")));
                ((Map)service.get("methods")).put(syncMethodName, syncMethod);
                continue;
            }
            this.log.error("Error Processing @async({}) in {}. Method {} already defined.", new Object[]{asyncMethod.get("name"), asyncMethod.get("serviceName"), syncMethodName});
        }
    }

    public void processCopyAnnotation(Map<String, Object> zdlModel) {
        HashMap allEntities = new HashMap();
        allEntities.putAll((Map)JSONPath.get(zdlModel, "$.allEntitiesAndEnums"));
        allEntities.putAll((Map)JSONPath.get(zdlModel, "$.events"));
        ArrayList entitiesToPopulate = new ArrayList();
        entitiesToPopulate.addAll((Collection)JSONPath.get(zdlModel, "$.allEntitiesAndEnums[*][?(@.options.copy)]"));
        entitiesToPopulate.addAll((Collection)JSONPath.get(zdlModel, "$.events[*][?(@.options.copy)]"));
        for (Map entity : entitiesToPopulate) {
            Object toCopyName = JSONPath.get(entity, "$.options.copy");
            Object entityToCopy = JSONPath.get(allEntities, "$." + toCopyName);
            if (entityToCopy == null) {
                this.log.error("Error Processing @copy({}) in {} {}", new Object[]{toCopyName, JSONPath.get(entity, "$.type"), JSONPath.get(entity, "$.name")});
                continue;
            }
            Map fieldsToCopy = JSONPath.get(entityToCopy, "$.fields", Map.of());
            Map entityFields = JSONPath.get(entity, "$.fields", Map.of());
            LinkedHashMap copiedFields = new LinkedHashMap();
            copiedFields.putAll(fieldsToCopy);
            copiedFields.putAll(entityFields);
            entityFields.clear();
            entityFields.putAll(copiedFields);
        }
    }

    protected void fillExtendsEntities(Map<String, Object> entity, Map<String, Object> zdlModel) {
        boolean isExtendsAuditing;
        String superClassName = (String)JSONPath.get(entity, "options.extends");
        JSONPath.set(zdlModel, "$.entities['" + superClassName + "'].options.isSuperClass", true);
        boolean bl = isExtendsAuditing = JSONPath.get(zdlModel, "$.entities['" + superClassName + "'].options.auditing") != null;
        if (isExtendsAuditing) {
            JSONPath.set(entity, "options.extendsAuditing", true);
        }
    }

    protected void fillCopyEntities(Map<String, Object> entity, Map<String, Object> zdlModel) {
        String entityName = (String)JSONPath.get(entity, "name");
        String superClassName = (String)JSONPath.get(entity, "options.copy");
        Map superClass = (Map)JSONPath.get(zdlModel, "$.entities['" + superClassName + "']");
        if (superClass != null) {
            Map fields = (Map)JSONPath.get(entity, "$.fields");
            Map superClassFields = (Map)JSONPath.get(superClass, "$.fields");
            for (Map.Entry fieldEntry : superClassFields.entrySet()) {
                if (fields.containsKey(fieldEntry.getKey())) continue;
                fields.put((String)fieldEntry.getKey(), (Map)fieldEntry.getValue());
            }
        }
    }

    protected void fillEntityRelationships(Map entity, Map zdlModel) {
        String entityName = (String)entity.get("name");
        List relationships = (List)JSONPath.get(zdlModel, "$.relationships[*][*][?(@.from == '" + entityName + "' || @.to == '" + entityName + "')]");
        entity.put("relationships", relationships.stream().map(r -> this.buildRelationship(entityName, (Map)r)).collect(Collectors.toList()));
    }

    protected Map buildRelationship(String entityName, Map relationship) {
        Map relationshipMap = Maps.of("type", relationship.get("type"), "_relationship", relationship);
        Object from = relationship.get("from");
        Object to = relationship.get("to");
        if (from.equals(entityName)) {
            String[] fillInjectedFieldInFrom;
            relationshipMap.put("entityName", from);
            relationshipMap.put("otherEntityName", to);
            relationshipMap.put("ownerSide", true);
            relationshipMap.put("options", relationship.get("fromOptions"));
            relationshipMap.put("validations", relationship.get("fromValidations"));
            relationshipMap.put("isCollection", relationship.get("type").toString().endsWith("Many"));
            if (relationship.get("injectedFieldInFrom") != null) {
                fillInjectedFieldInFrom = StringUtils.replace((String)((String)relationship.get("injectedFieldInFrom")), (String)")", (String)"").split("\\(");
                relationshipMap.put("fieldName", fillInjectedFieldInFrom[0]);
                relationshipMap.put("required", relationship.getOrDefault("isInjectedFieldInFromRequired", false));
            }
            if (relationship.get("injectedFieldInTo") != null) {
                fillInjectedFieldInFrom = StringUtils.replace((String)((String)relationship.get("injectedFieldInTo")), (String)")", (String)"").split("\\(");
                relationshipMap.put("otherEntityFieldName", fillInjectedFieldInFrom[0]);
            }
        } else {
            String[] fillInjectedFieldInFrom;
            relationshipMap.put("entityName", to);
            relationshipMap.put("otherEntityName", from);
            relationshipMap.put("ownerSide", false);
            relationshipMap.put("options", relationship.get("toOptions"));
            relationshipMap.put("validations", relationship.get("toValidations"));
            relationshipMap.put("mapsId", JSONPath.get(relationship, "toOptions.Id", false));
            relationshipMap.put("isCollection", relationship.get("type").toString().startsWith("Many"));
            if (relationship.get("injectedFieldInTo") != null) {
                fillInjectedFieldInFrom = StringUtils.replace((String)((String)relationship.get("injectedFieldInTo")), (String)")", (String)"").split("\\(");
                relationshipMap.put("fieldName", fillInjectedFieldInFrom[0]);
                relationshipMap.put("required", relationship.getOrDefault("isInjectedFieldInToRequired", false));
            }
            if (relationship.get("injectedFieldInFrom") != null) {
                fillInjectedFieldInFrom = StringUtils.replace((String)((String)relationship.get("injectedFieldInFrom")), (String)")", (String)"").split("\\(");
                relationshipMap.put("otherEntityFieldName", fillInjectedFieldInFrom[0]);
            }
        }
        return relationshipMap;
    }
}

