/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.templating;

import com.github.jknack.handlebars.Options;
import io.zenwave360.sdk.utils.JSONPath;
import io.zenwave360.sdk.utils.NamingUtils;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class CustomHandlebarsHelpers {
    public static String date(Object props, Options options) {
        return DateTimeFormatter.ISO_ZONED_DATE_TIME.format(OffsetDateTime.now());
    }

    public static String populateProperty(Map property, Options options) {
        String type = (String)property.get("type");
        String format = (String)property.get("format");
        List enums = (List)property.get("enum");
        if (enums != null && !enums.isEmpty()) {
            String otherEntity = (String)property.get("x--schema-name");
            String openApiModelNameSuffix = (String)options.hash("openApiModelNameSuffix", (Object)"");
            if (otherEntity == null) {
                return "\"null\"";
            }
            return String.format("%s%s.%s", otherEntity, openApiModelNameSuffix, StringUtils.upperCase((String)((String)enums.get(0))));
        }
        if ("date".equals(format)) {
            return "new Date()";
        }
        if ("date-time".equals(format)) {
            return "Instant.now()";
        }
        if ("integer".equals(type) && (StringUtils.isEmpty((CharSequence)format) || "int32".equals(format))) {
            return "1";
        }
        if ("integer".equals(type) && "int64".equals(format)) {
            return "1L";
        }
        if ("number".equals(type)) {
            return "BigDecimal.valueOf(0)";
        }
        if ("boolean".equals(type)) {
            return "true";
        }
        if ("array".equals(type)) {
            Map items = (Map)property.get("items");
            String propertyName = (String)property.get("x--property-name");
            return "null";
        }
        if (property.get("x--schema-name") != null) {
            String otherEntity = (String)property.get("x--schema-name");
            String propertyName = (String)property.get("x--property-name");
            String openApiModelNameSuffix = (String)options.hash("openApiModelNameSuffix", (Object)"");
            return "new " + otherEntity + openApiModelNameSuffix + "()";
        }
        return "\"aaa\"";
    }

    public static Object jsonPath(Object entity, Options options) throws IOException {
        String jsonPath = StringUtils.join((Object[])options.params, (String)"");
        Object defaultValue = options.hash.get("default");
        return JSONPath.get(entity, jsonPath, defaultValue);
    }

    public static String partial(String context, Options options) {
        String baseDir = FilenameUtils.getPath((String)options.fn.filename());
        List<String> baseDirTokens = List.of(baseDir.split("/"));
        while (context.startsWith("../")) {
            context = context.substring(3);
            baseDirTokens = baseDirTokens.subList(0, baseDirTokens.size() - 1);
        }
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.addAll(baseDirTokens);
        tokens.add(context);
        tokens.addAll(Arrays.stream(options.params).map(Object::toString).collect(Collectors.toList()));
        tokens.replaceAll(t -> t.replaceAll("^\\./", "").replaceAll("^/", "").replaceAll("/$", ""));
        return StringUtils.join(tokens, (String)"/");
    }

    public static String concat(String context, Options options) {
        ArrayList<Object> tokens = new ArrayList<Object>();
        tokens.add(context);
        tokens.addAll(List.of(options.params));
        return StringUtils.join(tokens, (String)"");
    }

    public static String path(String context, Options options) {
        ArrayList<Object> tokens = new ArrayList<Object>();
        tokens.add(context);
        tokens.addAll(List.of(options.params));
        return StringUtils.join(tokens, (String)"/").replaceAll("/+", "/");
    }

    public static boolean eq(Object first, Options options) throws IOException {
        Object second = options.param(0);
        return StringUtils.equals((CharSequence)String.valueOf(first), (CharSequence)String.valueOf(second));
    }

    public static boolean startsWith(String first, Options options) throws IOException {
        String second = (String)options.param(0);
        return StringUtils.startsWith((CharSequence)first, (CharSequence)second);
    }

    public static boolean endsWith(String first, Options options) throws IOException {
        String second = (String)options.param(0);
        return StringUtils.endsWith((CharSequence)first, (CharSequence)second);
    }

    public static boolean contains(String first, Options options) throws IOException {
        String second = (String)options.param(0);
        boolean ignoreCase = (Boolean)options.hash("ignoreCase", (Object)false);
        return ignoreCase ? StringUtils.containsIgnoreCase((CharSequence)first, (CharSequence)second) : StringUtils.contains((CharSequence)first, (CharSequence)second);
    }

    public static Object ifTruthy(Object value, Options options) throws IOException {
        if (CustomHandlebarsHelpers.isTruthy(value)) {
            return options.param(0, (Object)"");
        }
        return options.param(1, (Object)"");
    }

    public static boolean not(Object value, Options options) throws IOException {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        return Boolean.valueOf(String.valueOf(value)) == false;
    }

    public static boolean or(Object first, Options options) throws IOException {
        return CustomHandlebarsHelpers.isTruthy(first) || Stream.of(options.params).anyMatch(CustomHandlebarsHelpers::isTruthy);
    }

    public static boolean and(Object first, Options options) throws IOException {
        return CustomHandlebarsHelpers.isTruthy(first) && Stream.of(options.params).allMatch(CustomHandlebarsHelpers::isTruthy);
    }

    private static boolean isTruthy(Object value) {
        if (value == null) {
            return false;
        }
        if (value.toString().trim().equals("")) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return !"false".equalsIgnoreCase(String.valueOf(value));
    }

    public static Object size(List list, Options options) throws IOException {
        return list != null ? list.size() : 0;
    }

    public static Object uncapFirst(String text, Options options) throws IOException {
        return StringUtils.uncapitalize((String)text);
    }

    public static Object assign(String variableName, Options options) throws IOException {
        if (options.params.length == 1) {
            if (options.param(0) != null) {
                options.context.combine(Map.of(variableName, options.param(0)));
            }
        } else {
            CharSequence finalValue = options.apply(options.fn);
            options.context.combine(Map.of(variableName, finalValue.toString().trim()));
        }
        return null;
    }

    public static String asInstanceName(String text, Options options) throws IOException {
        return NamingUtils.asInstanceName(text);
    }

    public static String asJavaTypeName(String text, Options options) throws IOException {
        return NamingUtils.asJavaTypeName(text);
    }

    public static String asPackageFolder(String text, Options options) throws IOException {
        return NamingUtils.asPackageFolder(text);
    }

    public static String camelCase(String text, Options options) throws IOException {
        return text != null ? NamingUtils.camelCase(text) : null;
    }

    public static String kebabCase(String text, Options options) throws IOException {
        return text != null ? NamingUtils.kebabCase(text) : null;
    }

    public static String snakeCase(String text, Options options) throws IOException {
        return text != null ? NamingUtils.snakeCase(text) : null;
    }

    public static String joinWithTemplate(Object context, Options options) throws IOException {
        Collection items = context instanceof Map ? ((Map)context).entrySet() : (Set)context;
        String delimiter = (String)options.hash("delimiter", (Object)"\n");
        boolean removeDuplicates = (Boolean)options.hash("removeDuplicates", (Object)false);
        if (removeDuplicates) {
            items = items.stream().distinct().collect(Collectors.toList());
        }
        return items.stream().map(token -> {
            try {
                return options.fn(token);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.joining(delimiter));
    }
}

