/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.templating;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.helper.StringHelpers;
import io.zenwave360.sdk.templating.CustomHandlebarsHelpers;
import io.zenwave360.sdk.templating.TemplateEngine;
import io.zenwave360.sdk.templating.TemplateInput;
import io.zenwave360.sdk.templating.TemplateOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HandlebarsEngine
implements TemplateEngine {
    Context context;
    Handlebars handlebars = new Handlebars();

    public HandlebarsEngine() {
        this.context = Context.newBuilder(new HashMap()).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE}).build();
        this.handlebars.registerHelpers(CustomHandlebarsHelpers.class);
        this.handlebars.registerHelpers(StringHelpers.class);
    }

    public Handlebars getHandlebars() {
        return this.handlebars;
    }

    @Override
    public String processInline(String template, Map<String, Object> model) throws IOException {
        return this.handlebars.compileInline(template).apply(model);
    }

    @Override
    public List<TemplateOutput> processTemplate(Map<String, Object> model, TemplateInput templateInput) {
        return this.processTemplates(model, List.of(templateInput));
    }

    @Override
    public List<TemplateOutput> processTemplates(Map<String, Object> model, List<TemplateInput> templateInputs) {
        return this.processTemplates(null, model, templateInputs);
    }

    @Override
    public List<TemplateOutput> processTemplates(String modelPrefix, Map<String, Object> apiModel, List<TemplateInput> templateInputs) {
        Context context = Context.newBuilder((Object)this.context).build();
        if (modelPrefix != null) {
            context.combine(modelPrefix, apiModel);
        } else {
            context.combine(apiModel);
        }
        ArrayList<TemplateOutput> templateOutputList = new ArrayList<TemplateOutput>();
        templateInputs.forEach(templateInput -> {
            if (templateInput.getSkip() == null || !Boolean.TRUE.equals(templateInput.getSkip().apply(apiModel))) {
                try {
                    String targetFile = this.handlebars.compileInline(templateInput.getTargetFile()).apply(context);
                    String templateLocation = this.handlebars.compileInline(templateInput.getTemplateLocation()).apply(context);
                    String content = this.handlebars.compile(templateLocation).apply(context);
                    templateOutputList.add(new TemplateOutput(targetFile, content, templateInput.getMimeType(), templateInput.isSkipOverwrite()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return templateOutputList;
    }
}

