/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.utils;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class JSONPath {
    private static final Configuration config = Configuration.defaultConfiguration();

    public static <T> T get(Object object, String jsonPath) {
        if (object == null) {
            return null;
        }
        try {
            jsonPath = JSONPath.escapeByteArrayType(jsonPath);
            return (T)JsonPath.using((Configuration)config).parse(object).read(jsonPath, new Predicate[0]);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public static <T> T getFirst(Object object, String ... jsonPaths) {
        if (jsonPaths != null) {
            for (String jsonPath : jsonPaths) {
                T value = JSONPath.get(object, jsonPath);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    public static <T> T get(Object object, String jsonPath, T defaultIfNull) {
        if (object == null) {
            return null;
        }
        try {
            jsonPath = JSONPath.escapeByteArrayType(jsonPath);
            return (T)ObjectUtils.firstNonNull((Object[])new Object[]{JsonPath.using((Configuration)config).parse(object).read(jsonPath, new Predicate[0]), defaultIfNull});
        }
        catch (PathNotFoundException e) {
            return defaultIfNull;
        }
    }

    public static void set(Object object, String jsonPath, Object value) {
        if (jsonPath.contains(".")) {
            String[] tokens = jsonPath.split("\\.");
            Object nested = object;
            for (String token : tokens) {
                try {
                    nested = JsonPath.read((Object)nested, (String)token, (Predicate[])new Predicate[0]);
                }
                catch (PathNotFoundException e) {
                    ((Map)nested).put(token, new LinkedHashMap());
                    nested = ((Map)nested).get(token);
                }
            }
        }
        JsonPath.parse((Object)object).set(jsonPath, value, new Predicate[0]);
    }

    private static String escapeByteArrayType(String jsonPath) {
        if (jsonPath == null) {
            return null;
        }
        return jsonPath.replace(".byte[]", "['byte[]']");
    }
}

