/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface Maps {
    public static <K, V> V getOrCreateDefault(Map<K, V> map, K key, V defaultValue) {
        V value = map.getOrDefault(key, defaultValue);
        map.put(key, value);
        return value;
    }

    public static <K, V> Map<K, V> of(K key, V value, Object ... keyValues) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        map.put(key, value);
        if (keyValues != null) {
            int i = 0;
            while (i < keyValues.length) {
                Object k = keyValues[i++];
                Object v = keyValues[i++];
                map.put(k, v);
            }
        }
        return map;
    }

    public static Map copy(Map source) {
        return (Map)Maps.deepCopy(source);
    }

    private static Object deepCopy(Object source) {
        if (source instanceof Map) {
            source = new LinkedHashMap(source);
            ((HashMap)source).entrySet().forEach(e -> e.setValue(Maps.deepCopy(e.getValue())));
        } else if (source instanceof List) {
            source = new ArrayList((List)((Object)source));
        }
        return source;
    }

    public static Map deepMerge(Map target, Map extra) {
        for (Object key : extra.keySet()) {
            if (extra.get(key) instanceof Map) {
                HashMap subTarget = (HashMap)target.get(key);
                if (subTarget == null) {
                    subTarget = new HashMap();
                    target.put(key, subTarget);
                }
                Maps.deepMerge(subTarget, (Map)extra.get(key));
                continue;
            }
            target.put(key, extra.get(key));
        }
        return target;
    }
}

