/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.utils;

import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

public class NamingUtils {
    public static String plural(String name) {
        return name + "s";
    }

    public static String asJavaTypeName(String name) {
        return RegExUtils.removePattern((String)NamingUtils.camelCase(name), (String)"^(\\d+)");
    }

    public static String asInstanceName(String name) {
        if (name == null) {
            return null;
        }
        return StringUtils.uncapitalize((String)NamingUtils.camelCase(name)).replaceAll("<", "").replaceAll(">", "");
    }

    public static String asPackageFolder(String text) {
        return text != null ? text.replaceAll("\\.", "/") : null;
    }

    public static String camelCase(String name) {
        if (name == null) {
            return null;
        }
        Object[] tokens = RegExUtils.replaceAll((String)name, (String)"[\\s-.]", (String)" ").split(" ");
        for (int i = 0; i < tokens.length; ++i) {
            if (StringUtils.isAllUpperCase((CharSequence)tokens[i])) {
                tokens[i] = ((String)tokens[i]).toLowerCase();
            }
            tokens[i] = StringUtils.capitalize((String)tokens[i]);
        }
        return StringUtils.join((Object[])tokens);
    }

    public static String kebabCase(String value) {
        value = value.replaceAll("([a-z])([A-Z])", "$1-$2");
        value = value.replaceAll(" ", "-");
        value = value.replaceAll("--", "-");
        return value.toLowerCase();
    }

    public static String snakeCase(String value) {
        return NamingUtils.kebabCase(value).replaceAll("-", "_");
    }
}

