/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.zdl;

import io.zenwave360.sdk.utils.JSONPath;
import io.zenwave360.sdk.utils.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class ZDLFindUtils {
    public static List<String> findAllServiceFacingEntities(Map<String, Object> model) {
        List<String> serviceEntities = ZDLFindUtils.findMethodParameterAndReturnTypes(model);
        return ZDLFindUtils.findDependentEntities(model, serviceEntities);
    }

    public static List<Map<String, Object>> methodsWithEvents(Map<String, Object> model) {
        return JSONPath.get(model, "$.services[*].methods[*][?(@.withEvents.length() > 0)]", Collections.emptyList());
    }

    public static List<String> findAllPaginatedEntities(Map<String, Object> model) {
        return JSONPath.get(model, "$.services[*].methods[*][?(@.options.paginated == true)].returnType", List.of());
    }

    public static boolean isMethodPaginated(Map<String, Object> method) {
        return JSONPath.get(method, "$.options.paginated", false);
    }

    public static List<String> findAllEntitiesReturnedAsList(Map<String, Object> model) {
        return JSONPath.get(model, "$.services[*].methods[*][?(@.returnTypeIsArray == true && @.options.paginated != true)].returnType", List.of());
    }

    public static List<String> findDependentEntities(Map<String, Object> model, String entityName) {
        ArrayList<String> dependentEntities = new ArrayList<String>();
        dependentEntities.add(entityName);
        Map allEntitiesAndEnums = JSONPath.get(model, "$.allEntitiesAndEnums", Map.of());
        Map fields = JSONPath.get(model, "$.allEntitiesAndEnums." + entityName + ".fields", Map.of());
        for (Map field : fields.values()) {
            String fieldType = (String)field.get("type");
            if (!allEntitiesAndEnums.containsKey(fieldType)) continue;
            dependentEntities.add(fieldType);
            if (dependentEntities.contains(fieldType)) continue;
            dependentEntities.addAll(ZDLFindUtils.findDependentEntities(model, fieldType));
        }
        List<String> toRelationships = JSONPath.get(model, "$.relationships[*][*][?(@.from=='" + entityName + "')].to", List.of());
        for (String toRelationship : toRelationships) {
            dependentEntities.add(toRelationship);
            if (dependentEntities.contains(toRelationship)) continue;
            dependentEntities.addAll(ZDLFindUtils.findDependentEntities(model, toRelationship));
        }
        return dependentEntities;
    }

    public static List<String> findDependentEntities(Map<String, Object> model, List<String> entityNames) {
        System.out.println("entityNames = " + entityNames);
        return entityNames.stream().map(entityName -> ZDLFindUtils.findDependentEntities(model, entityName)).peek(System.out::println).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<String> findMethodParameterAndReturnTypes(Map<String, Object> model) {
        ArrayList entities = new ArrayList();
        entities.addAll((Collection)JSONPath.get(model, "$.services[*].methods[*]['parameter']"));
        entities.addAll((Collection)JSONPath.get(model, "$.services[*].methods[*]['returnType']"));
        return entities.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public static String findServiceName(String entityName, Map<String, Object> model) {
        Map entity = JSONPath.get(model, "$.allEntitiesAndEnums." + entityName, Map.of());
        List<Map> allServices = JSONPath.get(model, "$.services[*]", List.of());
        if ("entities".equals(entity.get("type"))) {
            String aggregateService = ZDLFindUtils._findServiceName(allServices, entityName, "$.aggregates");
            String parameterService = ZDLFindUtils._findServiceName(allServices, entityName, "$.methods[*].parameter");
            return (String)ObjectUtils.firstNonNull((Object[])new String[]{aggregateService, parameterService});
        }
        if ("inputs".equals(entity.get("type"))) {
            return ZDLFindUtils._findServiceName(allServices, entityName, "$.methods[*].parameter");
        }
        if ("outputs".equals(entity.get("type"))) {
            return ZDLFindUtils._findServiceName(allServices, entityName, "$.methods[*].returnType");
        }
        return null;
    }

    private static String _findServiceName(List<Map> services, String entityName, String jsonPath) {
        return services.stream().filter(service -> JSONPath.get(service, jsonPath, List.of()).contains(entityName)).map(service -> (String)service.get("name")).findFirst().orElse(null);
    }

    public static Map<String, Object> findServiceMethod(String operationId, Map<String, Object> model) {
        List methods = JSONPath.get(model, "$.services[*].methods[*]", List.of());
        return methods.stream().filter(method -> operationId.equals(JSONPath.get(method, "$.name")) || operationId.equals(JSONPath.get(method, "$.options[*].operationId"))).findFirst().orElse(null);
    }

    public static boolean isAggregateRoot(Map zdl, String entityName) {
        List aggregateNames = JSONPath.get(zdl, "$.aggregates[*][?(@.aggregateRoot == '" + entityName + "')].name", List.of());
        return !aggregateNames.isEmpty();
    }

    public static Set<String> aggregateEvents(Map<String, Object> aggregate) {
        HashSet<String> allEvents = new HashSet<String>();
        List<Map> methods = JSONPath.get(aggregate, "$.commands[*]", List.of());
        for (Map method : methods) {
            allEvents.addAll(ZDLFindUtils.methodEventsFlatList(method));
        }
        return allEvents;
    }

    public static List<String> methodEventsFlatList(Map<String, Object> method) {
        List events = method.getOrDefault("withEvents", List.of());
        ArrayList<String> allEvents = new ArrayList<String>();
        for (Object event : events) {
            if (event instanceof String) {
                allEvents.add((String)event);
                continue;
            }
            if (!(event instanceof List)) continue;
            allEvents.addAll((Collection)event);
        }
        return allEvents;
    }

    public static List<Map<String, Object>> findAggregateCommandsForMethod(Map zdl, Map<String, Object> method) {
        block4: {
            String commandName;
            String crudMethod;
            String entityName;
            String aggregateName;
            Object returnType;
            block6: {
                List serviceAggregateNames;
                block5: {
                    serviceAggregateNames = JSONPath.get(zdl, "$.services." + method.get("serviceName") + ".aggregates", List.of());
                    List methodAnnotatedAggregates = JSONPath.get(method, "$.options.aggregates", List.of());
                    returnType = JSONPath.get(method, "$.returnType");
                    if (!methodAnnotatedAggregates.isEmpty()) break block4;
                    aggregateName = null;
                    entityName = null;
                    crudMethod = null;
                    commandName = null;
                    if (serviceAggregateNames.size() != 1) break block5;
                    aggregateName = (String)serviceAggregateNames.get(0);
                    entityName = (String)JSONPath.get(zdl, "$.allEntitiesAndEnums." + aggregateName + ".aggregateRoot");
                    if (entityName == null) {
                        entityName = aggregateName;
                        aggregateName = null;
                    }
                    if ((commandName = ZDLFindUtils.findAggregateCommand(zdl, method, aggregateName)) != null || (crudMethod = ZDLFindUtils.findCrudMethod(zdl, method, entityName)) == null) break block6;
                    aggregateName = null;
                    break block6;
                }
                Iterator iterator = serviceAggregateNames.iterator();
                while (iterator.hasNext()) {
                    String serviceAggregate;
                    aggregateName = serviceAggregate = (String)iterator.next();
                    entityName = (String)JSONPath.get(zdl, "$.allEntitiesAndEnums." + serviceAggregate + ".aggregateRoot");
                    if (entityName == null) {
                        entityName = aggregateName;
                        aggregateName = null;
                    }
                    if ((Objects.equals(returnType, entityName) || Objects.equals(returnType, aggregateName)) && (commandName = ZDLFindUtils.findAggregateCommand(zdl, method, aggregateName)) != null) break;
                    crudMethod = ZDLFindUtils.findCrudMethod(zdl, method, entityName);
                    if (crudMethod == null && !Objects.equals(returnType, entityName)) continue;
                    aggregateName = null;
                    break;
                }
            }
            if (commandName == null && Objects.equals(returnType, entityName)) {
                aggregateName = null;
            }
            return List.of(ZDLFindUtils.methodAggregateCommand(zdl, aggregateName, commandName, entityName, crudMethod));
        }
        return null;
    }

    private static Map<String, Object> methodAggregateCommand(Map zdl, String aggregateName, String commandName, String entityName, String crudMethod) {
        Object aggregate = JSONPath.get(zdl, "$.allEntitiesAndEnums." + aggregateName);
        Object entity = JSONPath.get(zdl, "$.allEntitiesAndEnums." + entityName);
        Object command = JSONPath.get(aggregate, "$.commands." + commandName);
        return Maps.of("aggregate", aggregate, "entity", entity, "command", command, "crudMethod", crudMethod);
    }

    private static String findAggregateCommand(Map zdl, Map method, String aggregate) {
        return (String)JSONPath.get(zdl, "$.allEntitiesAndEnums." + aggregate + ".commands." + method.get("name") + ".name");
    }

    private static String findCrudMethod(Map zdl, Map method, String entityName) {
        Map entity = JSONPath.get(zdl, "$.allEntitiesAndEnums." + entityName, Map.of());
        return ZDLFindUtils.findCrudMethod(method, entity);
    }

    private static String findCrudMethod(Map method, Map entity) {
        String entityName = (String)entity.get("name");
        String entityNamePlural = (String)entity.get("classNamePlural");
        String methodName = (String)method.get("name");
        boolean isArray = "true".equals(String.valueOf(method.get("returnTypeIsArray")));
        boolean isOptional = "true".equals(String.valueOf(method.get("returnTypeIsOptional")));
        String entityMethodSuffix = isArray ? entityNamePlural : entityName;
        for (String crudPrefix : List.of("create", "delete", "get")) {
            boolean isCrudMethod = methodName.equals(crudPrefix + entityMethodSuffix);
            if (!isCrudMethod) continue;
            return crudPrefix + entityMethodSuffix;
        }
        return null;
    }
}

