/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.zdl;

import io.zenwave360.sdk.generators.EntitiesToSchemasConverter;
import io.zenwave360.sdk.utils.JSONPath;
import io.zenwave360.sdk.utils.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;

public class ZDLHttpUtils {
    private static final Pattern PATH_PARAM_PATTERN = Pattern.compile("\\{([a-zA-Z0-9-_]+)\\}");

    public static String getPathFromMethod(Map method) {
        Map<String, Object> httpOption = ZDLHttpUtils.getHttpOption(method);
        return ZDLHttpUtils.getPathFromMethodOptions(httpOption);
    }

    public static String getPathFromMethodOptions(Map httpOption) {
        if (httpOption == null) {
            return "";
        }
        Object httpOptions = httpOption.get("httpOptions");
        return httpOptions instanceof String ? (String)httpOptions : JSONPath.get(httpOptions, "$.path", "");
    }

    public static List<Map<String, Object>> getPathParamsAsObject(Map method, String idType, String idTypeFormat) {
        String path = ZDLHttpUtils.getPathFromMethod(method);
        Map<String, Object> httpOption = ZDLHttpUtils.getHttpOption(method);
        Map params = JSONPath.get(httpOption, "$.httpOptions.params", Map.of());
        return ZDLHttpUtils.getPathParams(path).stream().map(param -> {
            String type = params.getOrDefault(param, "String");
            Map<String, Object> typeAndFormat = EntitiesToSchemasConverter.schemaTypeAndFormat(type);
            if (!params.containsKey(param) && (param.startsWith("id") || param.endsWith("Id"))) {
                typeAndFormat.put("type", idType);
                typeAndFormat.put("format", idTypeFormat);
            }
            return Maps.of("name", param, "type", typeAndFormat.get("type"), "format", typeAndFormat.get("format"));
        }).toList();
    }

    public static List<Map<String, Object>> getQueryParamsAsObject(Map method) {
        List<String> pathParams = ZDLHttpUtils.getPathParamsFromMethod(method);
        Map<String, Object> httpOption = ZDLHttpUtils.getHttpOption(method);
        Map params = JSONPath.get(httpOption, "$.httpOptions.params", Map.of());
        return params.entrySet().stream().filter(entry -> !pathParams.contains(entry.getKey())).map(entry -> {
            Object type = entry.getValue();
            Map<String, Object> typeAndFormat = EntitiesToSchemasConverter.schemaTypeAndFormat((String)type);
            return Maps.of("name", entry.getKey(), "type", typeAndFormat.get("type"), "format", typeAndFormat.get("format"));
        }).toList();
    }

    public static List<String> getPathParamsFromMethod(Map method) {
        String path = ZDLHttpUtils.getPathFromMethod(method);
        return ZDLHttpUtils.getPathParams(path);
    }

    public static String getFirstPathParamsFromMethod(Map method) {
        List<String> pathParams = ZDLHttpUtils.getPathParamsFromMethod(method);
        return !pathParams.isEmpty() ? pathParams.get(0) : null;
    }

    public static List<String> getPathParams(String path) {
        Matcher matcher = PATH_PARAM_PATTERN.matcher(path);
        ArrayList<String> pathParams = new ArrayList<String>();
        while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String pathParam = matcher.group(i);
                pathParams.add(pathParam);
            }
        }
        return pathParams;
    }

    public static String getRequestBodyType(Map<String, Object> method, Map apiModel) {
        String methodParameterType = (String)method.get("parameter");
        Object parameterEntity = JSONPath.get(apiModel, "$.allEntitiesAndEnums." + methodParameterType);
        if (parameterEntity == null) {
            return null;
        }
        Boolean isInline = JSONPath.get(parameterEntity, "$.options.inline", false);
        if (isInline.booleanValue()) {
            Map fields = JSONPath.get(parameterEntity, "$.fields", Map.of());
            for (Map field : fields.values()) {
                if (!JSONPath.get(field, "$.isComplexType", false).booleanValue()) continue;
                return (String)JSONPath.get(field, "$.type");
            }
        }
        return methodParameterType;
    }

    public static Map<String, Object> getHttpOption(Map method) {
        String httpMethod;
        Object get = JSONPath.get(method, "$.options.get");
        Object put = JSONPath.get(method, "$.options.put");
        Object post = JSONPath.get(method, "$.options.post");
        Object delete = JSONPath.get(method, "$.options.delete");
        Object httpOptions = ObjectUtils.firstNonNull((Object[])new Object[]{get, put, post, delete});
        String string = get != null ? "get" : (put != null ? "put" : (post != null ? "post" : (httpMethod = delete != null ? "delete" : null)));
        if (httpMethod == null) {
            return null;
        }
        LinkedHashMap<String, Object> optionsMap = new LinkedHashMap<String, Object>();
        if (httpOptions instanceof String) {
            optionsMap.put("path", httpOptions);
        } else if (httpOptions instanceof Map) {
            optionsMap.putAll((Map)httpOptions);
        }
        return Map.of("httpMethod", httpMethod, "httpOptions", optionsMap);
    }
}

