/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk.zdl;

import io.zenwave360.sdk.parsers.ZDLParser;
import io.zenwave360.sdk.utils.JSONPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ZDLJavaSignatureUtils {
    public static String javaType(Map field) {
        return (String)field.get("type");
    }

    public static String methodParameterType(Map method, Map zdl, String inputDTOSuffix) {
        String parameterName = (String)method.get("parameter");
        boolean isEntity = JSONPath.get(zdl, "$.entities." + parameterName) != null;
        return String.format("%s%s", parameterName, isEntity ? inputDTOSuffix : "");
    }

    public static String methodParametersSignature(String idJavaType, Map method, Map zdl, String inputDTOSuffix) {
        ArrayList<Object> params = new ArrayList<Object>();
        if (JSONPath.get(method, "paramId") != null) {
            params.add(idJavaType + " id");
        }
        if (JSONPath.get(method, "parameter") != null) {
            params.addAll(ZDLJavaSignatureUtils.methodInputSignature(method, zdl, inputDTOSuffix));
        }
        if (JSONPath.get(method, "options.paginated") != null) {
            params.add("Pageable pageable");
        }
        return StringUtils.join(params, (String)", ");
    }

    public static String methodParametersCallSignature(Map method, Map zdl, String inputDTOSuffix) {
        return Arrays.stream(ZDLJavaSignatureUtils.methodParametersSignature("not-used", method, zdl, inputDTOSuffix).split(", ")).map(p -> p.contains(" ") ? p.split(" ")[1] : "").collect(Collectors.joining(", "));
    }

    private static List<String> methodInputSignature(Map method, Map zdl, String inputDTOSuffix) {
        return ZDLJavaSignatureUtils.inputSignature((String)method.get("parameter"), method, zdl, inputDTOSuffix);
    }

    public static String mapperInputSignature(String inputType, Map zdl, String inputDTOSuffix) {
        return StringUtils.join(ZDLJavaSignatureUtils.inputSignature(inputType, null, zdl, inputDTOSuffix), (String)", ");
    }

    public static String mapperInputCallSignature(String inputType, Map zdl) {
        return ZDLJavaSignatureUtils.inputSignature(inputType, null, zdl, "notused").stream().map(p -> p.split(" ")[1]).collect(Collectors.joining(", "));
    }

    public static String inputFieldInitializer(String inputType, Map zdl, String inputDTOSuffix) {
        return ZDLJavaSignatureUtils.inputSignature(inputType, null, zdl, inputDTOSuffix).stream().map(p -> p + " = null;\n").collect(Collectors.joining());
    }

    public static List<String> inputSignature(String inputType, Map method, Map zdl, String inputDTOSuffix) {
        ArrayList<String> params = new ArrayList<String>();
        if (inputType != null) {
            Boolean isInline = JSONPath.get(zdl, "$.inputs." + inputType + ".options.inline", false);
            Map fields = (Map)JSONPath.get(zdl, "$.inputs." + inputType + ".fields");
            if (isInline.booleanValue() && fields != null && !fields.isEmpty()) {
                for (Map.Entry field : fields.entrySet()) {
                    params.add(String.format("%s %s", ((Map)field.getValue()).get("type"), field.getKey()));
                }
            } else {
                String methodParameterType = method != null ? ZDLJavaSignatureUtils.methodParameterType(method, zdl, inputDTOSuffix) : inputType;
                params.add(methodParameterType + " input");
            }
        }
        return params;
    }

    public static List<String> methodInputCall(Map method, Map zdl, String inputDTOSuffix) {
        ArrayList<String> params = new ArrayList<String>();
        if (JSONPath.get(method, "parameter") != null) {
            String parameterType = (String)method.get("parameter");
            Boolean isInline = JSONPath.get(zdl, "$.inputs." + parameterType + ".options.inline", false);
            Map fields = (Map)JSONPath.get(zdl, "$.inputs." + parameterType + ".fields");
            if (isInline.booleanValue() && fields != null && !fields.isEmpty()) {
                for (Map.Entry field : fields.entrySet()) {
                    params.add((String)field.getKey());
                }
            } else {
                String methodParameterType = ZDLJavaSignatureUtils.methodParameterType(method, zdl, inputDTOSuffix);
                params.add(methodParameterType + " input");
            }
        }
        return params;
    }

    public static String methodReturnType(Map method) {
        boolean isAsync;
        String methodName = (String)method.get("name");
        Object returnType = method.get("returnType");
        Boolean returnTypeIsArray = method.getOrDefault("returnTypeIsArray", false);
        if (returnType == null) {
            return "void";
        }
        if (returnTypeIsArray.booleanValue()) {
            if (JSONPath.get(method, "options.paginated", false).booleanValue()) {
                return String.format("Page<%s>", returnType);
            }
            return String.format("List<%s>", returnType);
        }
        boolean isOptional = "true".equals(String.valueOf(method.get("returnTypeIsOptional")));
        if (isOptional) {
            return String.format("Optional<%s>", returnType);
        }
        boolean bl = isAsync = JSONPath.get(method, "options.async") != null;
        if (isAsync) {
            return String.format("CompletableFuture<%s>", returnType);
        }
        return (String)returnType;
    }

    public static String fieldType(Map field, String prefix, String suffix) {
        String type = ZDLJavaSignatureUtils.javaType(field);
        if (field.get("isArray") == Boolean.TRUE) {
            if ("byte".equalsIgnoreCase(type)) {
                return "byte[]";
            }
            return String.format("List<%s%s%s>", prefix, type, suffix);
        }
        if ("Map".equals(type)) {
            return "Map<String, Object>";
        }
        return String.format("%s%s%s", prefix, type, suffix);
    }

    public static String fieldTypeInitializer(Map field) {
        if (field.get("initialValue") != null) {
            return "= " + field.get("initialValue");
        }
        if (field.get("isArray") == Boolean.TRUE) {
            if ("byte".equalsIgnoreCase(String.valueOf(field.get("type")))) {
                return "";
            }
            return "= new ArrayList<>()";
        }
        return "";
    }

    public static String populateField(Map field) {
        Object value;
        if ("String".equals(field.get("type")) || "TextBlob".equals(field.get("type"))) {
            int min = Integer.valueOf(JSONPath.get(field, "validations.minlength.value", "0"));
            int max = Integer.valueOf(JSONPath.get(field, "validations.minlength.value", "0"));
            int middle = min + (max - min) / 2;
            value = "\"" + StringUtils.repeat((String)"a", (int)middle) + "\"";
        } else {
            value = JSONPath.get(field, "isEnum", false) != false ? field.get("type") + ".values()[0]" : ("LocalDate".equals(field.get("type")) ? "LocalDate.now()" : ("ZonedDateTime".equals(field.get("type")) ? "ZonedDateTime.now()" : ("Instant".equals(field.get("type")) ? "Instant.now()" : ("Duration".equals(field.get("type")) ? "Duration.ofSeconds(0)" : ("Integer".equals(field.get("type")) ? "0" : ("Long".equals(field.get("type")) ? "0L" : ("Float".equals(field.get("type")) ? "0.0F" : ("Double".equals(field.get("type")) ? "0.0" : ("BigDecimal".equals(field.get("type")) ? "BigDecimal.valueOf(0)" : ("Boolean".equals(field.get("type")) ? "false" : ("UUID".equals(field.get("type")) ? "UUID.randomUUID()" : (ZDLParser.blobTypes.contains(field.get("type")) ? "null" : ("Map".equals(field.get("type")) ? "new java.util.HashMap()" : "new " + field.get("type") + "()")))))))))))));
        }
        if (JSONPath.get(field, "isArray", false).booleanValue()) {
            return "List.of(" + (String)value + ")";
        }
        return value;
    }

    public static String relationshipFieldType(Map relationship, String prefix, String suffix) {
        String type = (String)relationship.get("otherEntityName");
        if (relationship.get("isCollection") == Boolean.TRUE) {
            return String.format("Set<%s%s%s>", prefix, type, suffix);
        }
        return String.format("%s%s%s", prefix, type, suffix);
    }

    public static String relationshipFieldTypeInitializer(Map relationship) {
        if (relationship.get("isCollection") == Boolean.TRUE) {
            return "= new HashSet<>()";
        }
        return "";
    }
}

