/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.sdk;

import io.zenwave360.sdk.MainGenerator;
import io.zenwave360.sdk.Plugin;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.artifact}", readonly=true, required=true)
    private Artifact projectArtifact;
    @Parameter(name="generatorName", property="zenwave.generatorName", required=true)
    private String generatorName;
    @Parameter(name="inputSpec", property="zenwave.inputSpec", required=true)
    private String inputSpec;
    @Parameter(name="targetFolder", property="zenwave.output", defaultValue="${project.build.directory}/generated-sources/zenwave")
    private File targetFolder;
    @Parameter(defaultValue="true")
    private boolean addCompileSourceRoot = true;
    @Parameter(defaultValue="false")
    private boolean addTestCompileSourceRoot = false;
    @Parameter(defaultValue="false")
    private boolean includeProjectClasspath = false;
    @Parameter(name="configOptions")
    private Map<String, Object> configOptions;
    @Parameter(name="configKeyValueOptions", property="zenwave.configOptions")
    private String configKeyValueOptions;
    @Parameter(name="skip", property="zenwave.skip", required=false, defaultValue="false")
    private Boolean skip;
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        this.addCompileSourceRootIfConfigured();
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"Code generation is skipped.");
            return;
        }
        try {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("basePackage", this.project.getGroupId());
            if (this.configOptions != null) {
                options.putAll(this.configOptions);
            }
            if (StringUtils.isNotBlank((CharSequence)this.configKeyValueOptions)) {
                options.putAll(this.buildConfigOptions(this.configKeyValueOptions));
            }
            URLClassLoader projectClassLoader = null;
            if (this.includeProjectClasspath) {
                List<URL> classpathFiles = this.getProjectClasspathElements(this.project);
                projectClassLoader = new URLClassLoader(classpathFiles.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
            }
            String specFile = this.inputSpec.startsWith("classpath:") ? this.inputSpec : new File(this.inputSpec).toURI().toString();
            Plugin plugin = Plugin.of((String)this.generatorName).withSpecFile(specFile).withTargetFolder(this.targetFolder.getAbsolutePath()).withProjectClassLoader((ClassLoader)projectClassLoader).withOptions(options);
            new MainGenerator().generate(plugin);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Code generation failed. See above for the full exception.");
        }
    }

    protected Map<String, String> buildConfigOptions(String configOptions) {
        Map<String, String> configMap = Arrays.asList(configOptions.split("\n")).stream().filter(str -> StringUtils.isNotBlank((CharSequence)str)).map(str -> str.split("=", 2)).collect(Collectors.toMap(split -> StringUtils.trim((String)split[0]), split -> StringUtils.trim((String)split[1])));
        return configMap;
    }

    private String getCompileSourceRoot() {
        Object sourceFolderObject = this.configOptions == null ? null : this.configOptions.get("sourceFolder");
        String sourceFolder = sourceFolderObject == null ? "src/main/java" : sourceFolderObject.toString();
        return new File(this.targetFolder, sourceFolder).getAbsolutePath();
    }

    private String getTestCompileSourceRoot() {
        Object sourceFolderObject = this.configOptions == null ? null : this.configOptions.get("testSourceFolder");
        String sourceFolder = sourceFolderObject == null ? "src/test/java" : sourceFolderObject.toString();
        return new File(this.targetFolder, sourceFolder).getAbsolutePath();
    }

    private void addCompileSourceRootIfConfigured() {
        if (this.addCompileSourceRoot) {
            String compileSourceRoot = this.getCompileSourceRoot();
            System.out.println("Adding source root " + compileSourceRoot);
            this.project.addCompileSourceRoot(compileSourceRoot);
        }
        if (this.addTestCompileSourceRoot) {
            String testCompileSourceRoot = this.getTestCompileSourceRoot();
            System.out.println("Adding tests source root " + testCompileSourceRoot);
            this.project.addTestCompileSourceRoot(testCompileSourceRoot);
        }
    }

    private List<URL> getProjectClasspathElements(MavenProject project) {
        ArrayList<File> list = new ArrayList<File>();
        project.getResources().stream().map(r -> new File(r.getDirectory())).forEach(list::add);
        list.add(new File(project.getBuild().getOutputDirectory()));
        list.addAll(project.getArtifacts().stream().map(Artifact::getFile).collect(Collectors.toList()));
        return list.stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }
}

